% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_sd_gp.R
\name{compute_sd_gp}
\alias{compute_sd_gp}
\title{Compute posterior credible interval}
\usage{
compute_sd_gp(
  w,
  scaled_obs,
  hyperparam,
  sigma,
  gps_m,
  kernel_fn = function(x) exp(-x^2)
)
}
\arguments{
\item{w}{A scalar of exposure level of interest.}

\item{scaled_obs}{A matrix of two columns.
\itemize{
\item First column is the scaled GPS value of all samples (GPS * 1/sqrt(alpha))
\item Second column is the scaled exposure value of all samples
(w * 1/sqrt(beta))
}}

\item{hyperparam}{A vector of hyper-parameters for the GP.
\itemize{
\item First element: alpha
\item Second element: beta
\item Third element: gamma/sigma
}}

\item{sigma}{A scaler that represents noise.}

\item{gps_m}{An S3 gps object including:
gps: A data.frame of GPS vectors.
- Column 1: GPS
- Column 2: Prediction of exposure for covariate of each data sample
(e_gps_pred).
- Column 3: Standard deviation of  e_gps (e_gps_std)
used_params:
- dnorm_log: TRUE or FLASE}

\item{kernel_fn}{The covariance function of GP.}
}
\value{
Posterior credible interval (scaler) for the requested exposure level (w).
}
\description{
Computes posterior credible interval for requested exposure level.
}
\keyword{internal}
