% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_rl_deriv_gp.R
\name{compute_rl_deriv_gp}
\alias{compute_rl_deriv_gp}
\title{Detect change-point in standard GP}
\usage{
compute_rl_deriv_gp(
  w,
  w_obs,
  y_obs,
  gps_m,
  hyperparam,
  kernel_fn = function(x) exp(-x),
  kernel_deriv_fn = function(x) -exp(-x)
)
}
\arguments{
\item{w}{A scalar of exposure level of interest.}

\item{w_obs}{A vector of observed exposure levels of all samples.}

\item{y_obs}{A vector of observed outcome values of all samples.}

\item{gps_m}{An S3 gps object including:
gps: A data.frame of GPS vectors.
- Column 1: GPS
- Column 2: Prediction of exposure for covariate of each data sample
(e_gps_pred).
- Column 3: Standard deviation of  e_gps (e_gps_std)
used_params:
- dnorm_log: TRUE or FLASE}

\item{hyperparam}{A vector of hyper-parameters in the GP model.}

\item{kernel_fn}{The covariance function.}

\item{kernel_deriv_fn}{The partial derivative of the covariance function.}
}
\value{
A numeric value of the posterior mean of the difference between two one-sided
derivatives.
}
\description{
Calculates the posterior mean of the difference between left- and
right-derivatives at an exposure level for the detection of change points.
}
\examples{
\donttest{
set.seed(847)
data <- generate_synthetic_data(sample_size = 100)
gps_m <- estimate_gps(cov_mt = data[,-(1:2)],
                      w_all = data$treat,
                      sl_lib = c("SL.xgboost"),
                      dnorm_log = FALSE)

wi <- 8.6

val <- compute_rl_deriv_gp(w = wi,
                           w_obs = data$treat,
                           y_obs = data$Y,
                           gps_m = gps_m,
                           hyperparam = c(1,1,2))
}
}
