% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaSPUtils.R
\name{gp.fisher}
\alias{gp.fisher}
\title{Fisher information matrix}
\usage{
gp.fisher(
  obj = NULL,
  intloglik = FALSE,
  formula = ~1,
  input = NULL,
  param = NULL,
  cov.model = NULL,
  dtype = "Euclidean"
)
}
\arguments{
\item{obj}{a \code{\link{gp}} object. It is optional with default value \code{NULL}.}

\item{intloglik}{a logical value with default value \code{FALSE}. If it is \code{FALSE}, Fisher information matrix \eqn{I(\sigma^2, \boldsymbol \theta)}
is derived based on the standard likelihood; otherwise, Fisher information matrix \eqn{I(\sigma^2, \boldsymbol \theta)}
is derived based on the integrated likelihood.}

\item{formula}{an object of \code{formula} class that specifies regressors; see \code{\link[stats]{formula}} for details.}

\item{input}{a matrix including inputs in a GaSP}

\item{param}{a list including values for regression parameters, covariance parameters, 
and nugget variance parameter.
The specification of \strong{param} should depend on the covariance model. 
\itemize{
\item{The regression parameters are denoted by \strong{coeff}. Default value is \eqn{\mathbf{0}}.}
\item{The marginal variance or partial sill is denoted by \strong{sig2}. Default value is 1.}
\item{The nugget variance parameter is denoted by \strong{nugget} for all covariance models. 
Default value is 0.}
\item{For the Confluent Hypergeometric class, \strong{range} is used to denote the range parameter \eqn{\beta}. 
\strong{tail} is used to denote the tail decay parameter \eqn{\alpha}. \strong{nu} is used to denote the 
smoothness parameter \eqn{\nu}.}
\item{For the generalized Cauchy class, \strong{range} is used to denote the range parameter \eqn{\phi}. 
\strong{tail} is used to denote the tail decay parameter \eqn{\alpha}. \strong{nu} is used to denote the 
smoothness parameter \eqn{\nu}.}
\item{For the Matérn class, \strong{range} is used to denote the range parameter \eqn{\phi}. 
\strong{nu} is used to denote the smoothness parameter \eqn{\nu}. When \eqn{\nu=0.5}, the 
Matérn class corresponds to the exponential covariance.}  
\item{For the powered-exponential class, \strong{range} is used to denote the range parameter \eqn{\phi}.
\strong{nu} is used to denote the smoothness parameter. When \eqn{\nu=2}, the powered-exponential class
corresponds to the Gaussian covariance.}
}}

\item{cov.model}{a list of two strings: \strong{family}, \strong{form}, where \strong{family} indicates the family of covariance functions 
including the Confluent Hypergeometric class, the Matérn class, the Cauchy class, the powered-exponential class. \strong{form} indicates the 
specific form of covariance structures including the isotropic form, tensor form, automatic relevance determination form. 
\describe{
\item{\strong{family}}{
\describe{
\item{CH}{The Confluent Hypergeometric correlation function is given by 
\deqn{C(h) = \frac{\Gamma(\nu+\alpha)}{\Gamma(\nu)} 
\mathcal{U}\left(\alpha, 1-\nu, \left(\frac{h}{\beta}\right)^2\right),}
where \eqn{\alpha} is the tail decay parameter. \eqn{\beta} is the range parameter.
\eqn{\nu} is the smoothness parameter. \eqn{\mathcal{U}(\cdot)} is the confluent hypergeometric
function of the second kind. For details about this covariance, 
see Ma and Bhadra (2019) at \url{https://arxiv.org/abs/1911.05865}.  
}
\item{cauchy}{The generalized Cauchy covariance is given by
\deqn{C(h) = \left\{ 1 + \left( \frac{h}{\phi} \right)^{\nu}  
            \right\}^{-\alpha/\nu},}
where \eqn{\phi} is the range parameter. \eqn{\alpha} is the tail decay parameter.
\eqn{\nu} is the smoothness parameter with default value at 2.
}

\item{matern}{The Matérn correlation function is given by
\deqn{C(h)=\frac{2^{1-\nu}}{\Gamma(\nu)} \left( \frac{h}{\phi} \right)^{\nu} 
\mathcal{K}_{\nu}\left( \frac{h}{\phi} \right),}
where \eqn{\phi} is the range parameter. \eqn{\nu} is the smoothness parameter. 
\eqn{\mathcal{K}_{\nu}(\cdot)} is the modified Bessel function of the second kind of order \eqn{\nu}.
}
\item{exp}{The exponential correlation function is given by 
\deqn{C(h)=\exp(-h/\phi),}
where \eqn{\phi} is the range parameter. This is the Matérn correlation with \eqn{\nu=0.5}.
}
\item{matern_3_2}{The Matérn correlation with \eqn{\nu=1.5}.}
\item{matern_5_2}{The Matérn correlation with \eqn{\nu=2.5}.}


\item{powexp}{The powered-exponential correlation function is given by
               \deqn{C(h)=\exp\left\{-\left(\frac{h}{\phi}\right)^{\nu}\right\},}
where \eqn{\phi} is the range parameter. \eqn{\nu} is the smoothness parameter.
}
\item{gauss}{The Gaussian correlation function is given by 
\deqn{C(h)=\exp\left(-\frac{h^2}{\phi^2}\right),}
where \eqn{\phi} is the range parameter.
 }
}
}

\item{\strong{form}}{
\describe{
 \item{isotropic}{This indicates the isotropic form of covariance functions. That is,
 \deqn{C(\mathbf{h}) = C^0(\|\mathbf{h}\|; \boldsymbol \theta),} where \eqn{\| \mathbf{h}\|} denotes the 
Euclidean distance or the great circle distance for data on sphere. \eqn{C^0(\cdot)} denotes 
any isotropic covariance family specified in \strong{family}.}
 \item{tensor}{This indicates the tensor product of correlation functions. That is, 
\deqn{ C(\mathbf{h}) = \prod_{i=1}^d C^0(|h_i|; \boldsymbol \theta_i),}
where \eqn{d} is the dimension of input space. \eqn{h_i} is the distance along the \eqn{i}th input dimension. This type of covariance structure has been often used in Gaussian process emulation for computer experiments.
}
 \item{ARD}{This indicates the automatic relevance determination form. That is, 
\deqn{C(\mathbf{h}) = C^0\left(\sqrt{\sum_{i=1}^d\frac{h_i^2}{\phi^2_i}}; \boldsymbol \theta \right),}
where \eqn{\phi_i} denotes the range parameter along the \eqn{i}th input dimension.}
 }
}

}}

\item{dtype}{a string indicating the type of distance:
\describe{
\item{Euclidean}{Euclidean distance is used. This is the default choice.}
\item{GCD}{Great circle distance is used for data on sphere.}
}}
}
\value{
a numerical matrix of Fisher information
}
\description{
This function computes the Fisher information matrix \eqn{I(\sigma^2, \boldsymbol \theta)} for a 
Gaussian process model. 
The standard likelihood is defined as 
\deqn{ L(\mathbf{b}, \sigma^2, \boldsymbol \theta; \mathbf{y}) = \mathcal{N}_n(\mathbf{H}\mathbf{b}, \sigma^2 \mathbf{R}),
}
where \eqn{\mathbf{y}:=(y(\mathbf{x}_1), \ldots, y(\mathbf{x}_n))^\top} is a vector of \eqn{n} observations.
\eqn{\mathbf{H}} is a matrix of covariates, \eqn{\mathbf{b}} is a vector of regression coefficients, 
\eqn{\sigma^2} is the variance parameter, \eqn{\boldsymbol \theta} contains correlation
parameters and nugget parameter, \eqn{\mathbf{R}} denotes the correlation matrix 
plus nugget variance on the main diagonal.

The integrated likelihood is defined as
\deqn{
 L^{I}(\sigma^2, \boldsymbol \theta; \mathbf{y}) = \int L(\mathbf{b}, \sigma^2, \boldsymbol \theta; \mathbf{y}) \pi^{R}(\mathbf{b} \mid \sigma^2, \boldsymbol \theta) d \mathbf{b},
}
where \eqn{\pi^{R}(\mathbf{b} \mid \sigma^2, \boldsymbol \theta)=1} is the conditional Jeffreys-rule (or reference prior) 
in the model with the above standard likelihood when \eqn{(\sigma^2, \boldsymbol \theta)} is assumed to be known.

\itemize{
\item{For the Matérn class, current implementation only computes Fisher information matrix 
for variance parameter \eqn{\sigma^2}, range parameter \eqn{\phi}, and nugget variance 
parameter \eqn{\tau^2}. That is, \eqn{I(\sigma^2, \boldsymbol \theta) = I(\sigma^2, \phi, \tau^2)}.
}
\item{For the Confluent Hypergeometric class, current implementation computes Fisher information matrix
 for variance parameter \eqn{\sigma^2}, range parameter \eqn{\beta}, tail decay parameter \eqn{\alpha}, smoothness parameter \eqn{\nu} and nugget variance 
parameter \eqn{\tau^2}. That is, \eqn{I(\sigma^2, \boldsymbol \theta) = I(\sigma^2, \beta, \alpha, \nu, \tau^2)}.
}
}
}
\examples{
 
n=100
input = seq(0, 20, length=n)
range = 1
tail = .5
nu = 1.5
sig2 = 1
nugget = 0.01
coeff = 0
par = list(range=range, tail=tail, nu=nu, sig2=sig2, nugget=nugget, coeff=coeff)
I = gp.fisher(formula=~1, input=input, 
        param=list(range=4, nugget=0.1,nu=2.5),
        cov.model=list(family="CH", form="isotropic"))
}
\seealso{
\link{GPBayes-package}, \code{\link{GaSP}}, \code{\link{gp}}, \code{\link{kernel}}, \code{\link{ikernel}},
}
\author{
Pulong Ma \email{mpulong@gmail.com}
}
