% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gotermlevelmf.R
\name{Level2GOTermMF}
\alias{Level2GOTermMF}
\title{GO molecular function (MF) terms on a level}
\usage{
Level2GOTermMF(level, organism = NULL)
}
\arguments{
\item{level}{A numeric value for the GO-level}

\item{organism}{The organism of interest. If NULL the results will be from the general GO MF tree}
}
\value{
A list of GO-terms from the level
}
\description{
Gets all the molecular function (MF) GO-terms on a GO-level.
             The supported organisms are "Homo sapiens / Human", "Rattus norvegicus / Rat", "Mus musculus / Mouse",
             "Danio rerio / Zebrafish",
             "Caenorhabditis elegans / Worm" ,"Arabidopsis thaliana / Cress", "Saccharomyces cerevisiae / Yeast",
             "Schizosaccharomyces pombe / Fission yeast",
             "Drosophila melanogaster / Fruit fly", "Escherichia coli / E.coli".
}
\note{
The Gene Ontology (GO) molecular function (MF) tree was built using the root node GO:0003674
}
\examples{
# Gene association GO-terms for organism Mouse on level 9
Level2GOTermMF(level = 9, organism = "mouse")

# Gene association GO-terms for organism Zebrafish on level 10
Level2GOTermMF(level = 10, organism = "zebrafish")

}
