% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supportedOrganism.R
\name{visRDAGCC}
\alias{visRDAGCC}
\title{Species-specific cellular component GO-DAG}
\usage{
visRDAGCC(organism, plot = TRUE)
}
\arguments{
\item{organism}{The organism supported by the package. Both the scientific / common name of the organism can be use
to derive the Sub-DAG.  If this argument
is "CC" the general CC GO-DAG is visualised.}

\item{plot}{If TRUE, both the reduced DAG and the GO-terms contained in each node is derived}
}
\value{
A list containing the plot of the DAG and all the GO-terms presents in each node
}
\description{
A sub-dag of cellular component terms for a certain species e.g DAG of the gene association terms for
              Arabidopsis thaliana.The label "J","R" and "L" on the right side of the plot
             gives the number of connections between the regular node (RN) on the level and the
             nodes right below it (RN are nodes that have all their children nodes represented in the next level). The supported organisms are "Homo sapiens / human", "Rattus norvegicus / Rat",
              "Mus musculus / Mouse",
              "Danio rerio / Zebrafish",
             "Caenorhabditis elegans / Worm" ,"Arabidopsis thaliana / cress", "Saccharomyces cerevisiae / Yeast",
              "Schizosaccharomyces pombe / Fission yeast",
             "Drosophila melanogaster / Fruit fly", "Escherichia coli / E.coli".
}
\examples{
# Reduced GO-DAG for Arabidopsis thaliana
visRDAGCC(organism = "Arabidopsis thaliana")

# Reduced GO-DAG for Saccharomyces cerevisiae
visRDAGCC(organism = "Worm")

# RN GO-terms on level 2 can be access as follows
visRDAGCC(organism = "Human", plot = FALSE)$"L2 RN"

# JN GO-terms on level 12 can be access as follows
visRDAGCC(organism = "Human", plot = FALSE)$"L12 JN"

# LN GO-terms on level 16 can be access as follows
visRDAGCC(organism = "Human", plot = FALSE)$"L16 LN"

}
