% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RegularNode.R
\name{Level2RegularNodeMF}
\alias{Level2RegularNodeMF}
\title{Regular nodes from a GO MF level}
\usage{
Level2RegularNodeMF(level, organism = NULL)
}
\arguments{
\item{level}{A numeric value for the GO-level}

\item{organism}{Organism of interest that is supported by the package}
}
\value{
Regular nodes from the GO-level
}
\description{
The function retrieves the Regular nodes (RNs) from a GO-level. RNs are those GO-terms which have all their
             children in the next GO-level (i.e level = level of parent + 1). If the optional
             parameter "organism" is missing
             then the result will be from the general GO tree instead of from a particular organism. The supported organisms
             are "Homo sapiens / Human", "Rattus norvegicus / Rat", "Mus musculus / Mouse", "Danio rerio / Zebrafish",
             "Caenorhabditis elegans / Worm" ,"Arabidopsis thaliana / Cress", "Saccharomyces cerevisiae / Yeast",
             "Schizosaccharomyces pombe / Fission yeast",
             "Drosophila melanogaster / Fruit fly", "Escherichia coli / E.coli".
}
\examples{
# Regular nodes on level 3
Level2RegularNodeMF(level = 3, organism = "Human" )

# Regular nodes on level 6
Level2RegularNodeMF(level = 6, organism = "MUS MUSCULUS" )
}
