% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.ss.ng.studyend.GNG.r
\name{get.ss.ng.studyend.GNG}
\alias{get.ss.ng.studyend.GNG}
\title{Get single sample normal-gamma study-end GNG}
\usage{
get.ss.ng.studyend.GNG(
  mu.0.t = 0,
  alpha.0.t = 0.25,
  beta.0.t = 1,
  n.0.t = 10,
  xbar.t = 1.97,
  s.t = 2,
  n.t = 20,
  Delta.lrv = 1.25,
  Delta.tv = 1.75,
  tau.tv = 0.1,
  tau.lrv = 0.8,
  tau.ng = 0.65
)
}
\arguments{
\item{mu.0.t}{prior mean for treatment group}

\item{alpha.0.t}{prior alpha parameter for treatment group}

\item{beta.0.t}{prior beta parameter for treatment group}

\item{n.0.t}{prior effective sample size for treatment group}

\item{xbar.t}{sample mean for treatment group}

\item{s.t}{sample sd for treatment group}

\item{n.t}{sample size for treatment group}

\item{Delta.lrv}{TPP Lower Reference Value aka Min TPP}

\item{Delta.tv}{TPP Target Value aka Base TPP}

\item{tau.tv}{threshold associated with Base TPP}

\item{tau.lrv}{threshold associated with Min TPP}

\item{tau.ng}{threshold associated with No-Go}
}
\value{
returns a list of data.frames holding what is needed from data for study-end Go/No-Go
}
\description{
Get single sample normal-gamma study end GNG
}
\examples{
my.ss.mg.studyend.GNG <- get.ss.ng.studyend.GNG(mu.0.t = 0, alpha.0.t=.25, beta.0.t = 1,
n.0.t = 10, xbar.t = 1.97, s.t = 2, n.t = 20, Delta.lrv = 1.25, Delta.tv = 1.75,
tau.tv=.1, tau.lrv=.8, tau.ng=.65)
my.ss.mg.studyend.GNG
}
