% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.ss.bin.int.oc.sim.r
\name{get.ss.bin.int.oc.sim}
\alias{get.ss.bin.int.oc.sim}
\title{Get single sample binary interim operating charactersitics simulations}
\usage{
get.ss.bin.int.oc.sim(InterimGNG, TrueRate, runs = 500)
}
\arguments{
\item{InterimGNG}{GNG decision value outputs from get.ss.bin.int.GNG}

\item{TrueRate}{assumed true response rate. Can be a vector}

\item{runs}{number of simulation runs}
}
\value{
Returns results of a simulation.
}
\description{
Get single sample binary interim operating charactersitics simulations
}
\examples{
\donttest{
my.ss.bin.int.df <- get.ss.bin.int.df(ss.bin.studyend.GNG =
get.ss.bin.studyend.GNG(a.trt = 1, b.trt = 1, n.trt = 40, x.trt = 9,
                        Delta.lrv = .2, Delta.tv = .35,
                        tau.tv = 0.10, tau.lrv = .80, tau.ng = .65),
                   goThreshold = .8,
                   nogoThreshold = 1.2,
                   include_nogo = TRUE)
my.ss.bin.studyend.GNG <- get.ss.bin.studyend.GNG(a.trt = 1, b.trt = 1, n.trt = 40, x.trt = 9,
                                                  Delta.lrv = .2, Delta.tv = .35,
                                                  tau.tv = 0.10, tau.lrv = .80, tau.ng = .65)
my.ss.bin.int.GNG <- get.ss.bin.int.GNG( ss.bin.int.df = my.ss.bin.int.df,
                                        Interims = 20,
                                        ss.bin.studyend.GNG = my.ss.bin.studyend.GNG)
my.ss.bin.int.GNG
}
}
