% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_gmse_effort}
\alias{plot_gmse_effort}
\title{Plot the effort made by each user for each action}
\usage{
plot_gmse_effort(sim_results)
}
\arguments{
\item{sim_results}{Output from gmse to be plotted.}
}
\value{
This function plots the permissiveness that each manager exhibits for each user action (scaring, culling, etc.) and the effort that each individual user puts into each action over time. On the left axis, permissiveness is calculated as 100 minus the percent of the manager's budget put into increasing the cost of a particular action, so, e.g., if a manager puts all of their effort into increasing the cost of culling, then permissiveness of culling is 0; if they put none of their effort into increasing the cost of culling, then permissiveness of culling is 100. On the right axis, percentage of user action expended is the percent of a user's budget put into a particular action (note, these might not add up to 100 because users are not forced to use their entire budget). Coloured lines that are above black lines could potentially (cautiously) be interpreted as conflict between managers and users.
}
\description{
Produce a five panel plot in which each panel compares the permissiveness of each action (scaring, culling, etc.) from the manager with the effort put into each action by individual users.
}
\examples{
\dontrun{
plot_gmse_effort(sim_results = sim);
}
}
