% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.theta.R
\name{plot.theta}
\alias{plot.theta}
\title{Plotting method for "theta" objects}
\usage{
\method{plot}{theta}(x, which.dims = c(1L, 2L), n.sd = 2,
  add.means = TRUE, ..., add.ellipses = FALSE)
}
\arguments{
\item{x}{An object of class \code{theta}.}

\item{which.dims}{An integer vector of length 2 choosing which two dimensions
to plot.}

\item{n.sd}{An integer choosing the number of standard deviations in each
dimension to determine the plotting window.}

\item{add.means}{logical. If TRUE, dots corresponding to the means are
added to the plot.}

\item{...}{Arguments passed to \code{contour}.}

\item{add.ellipses}{logical. If TRUE, ellipses outlining a 95\% confidence
regions for each component are added in the bivariate multivariate
distribution defined by theta and \code{which.dims}.}
}
\value{
Plots via the \code{contour} function. Invisibly returns a list with
  x, y, z coordinates that is passed to contour.
}
\description{
Visualizes the chosen dimensions of the theta object graphically by the GMM
density and possibly the individual gaussian components.
}
\examples{
set.seed(5)
theta <- rtheta(d = 3, m = 4)
\dontrun{
plot(theta)
plot(theta, col = "blue", asp = 1, add.means = FALSE)
plot(theta, col = "blue", asp = 1, add.means = TRUE)
plot(theta, which.dims = c(3L, 2L), asp = 1)
}
plot(theta, asp = 1, n.sd = 3, add.ellipses = TRUE,
     nlevels = 40, axes = FALSE,
     xlab = "Dimension 1", ylab = "Dimension 2")
}
\author{
Anders Ellern Bilgrau <anders.ellern.bilgrau@gmail.com>
}
