% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/EStep.R, R/MStep.R
\name{EStep}
\alias{EStep}
\alias{MStep}
\title{Steps of the EM algorithm for a Gaussian Mixture model}
\usage{
EStep(x, theta)

MStep(x, kappa, meta.special.case = FALSE)
}
\arguments{
\item{x}{A matrix of observations where rows corresponds to features and
columns to experiments.}

\item{theta}{A list of parameters formatted as described in
\code{\link{rtheta}}.}

\item{kappa}{A matrix where the (i,j)'th entry is the probability that
  \code{x[i,]} belongs to the \code{j}'th component. Usually the returned
value of \code{EStep}.}

\item{meta.special.case}{Logical. If \code{TRUE}, the maximization step is
  performed under the special case of Li et. al. (2011). Default values is
\code{FALSE}.}
}
\value{
\code{EStep} returns a matrix of probabilities as \code{kappa}
  above.

\code{MStep} returns a list of parameters formatted as described in
  \code{\link{rtheta}}.
}
\description{
Functions to perform the expectation and maximization steps of the EM
algorithm for an multivariate Gaussian mixture model.
}
\examples{
set.seed(1)
sim <- GMCM:::SimulateGMMData(n = 100)
x <- sim$z
true.theta <- sim$theta
init.theta <- GMCM:::rtheta()  # Generate starting parameters

# Do one EM interation
es <- GMCM:::EStep(x, init.theta)
new.theta <- GMCM:::MStep(x, es)

# Compare current estimate with the true
new.theta
true.theta
}
\author{
Anders Ellern Bilgrau (abilgrau@math.aau.dk)
}
\references{
Li, Q., Brown, J. B. J. B., Huang, H., & Bickel, P. J. (2011).
  Measuring reproducibility of high-throughput experiments. The Annals of
  Applied Statistics, 5(3), 1752-1779. doi:10.1214/11-AOAS466
}
\seealso{
\code{\link{rtheta}}
}
\keyword{internal}

