% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigma.R
\name{sigma.cglmm}
\alias{sigma.cglmm}
\title{Extract residual standard deviation or dispersion parameter}
\usage{
\method{sigma}{cglmm}(object, ...)
}
\arguments{
\item{object}{An object of class \code{cglmm}.}

\item{...}{(ignored; for method compatibility)}
}
\value{
a \code{numeric}.
}
\description{
see \code{?glmmTMB::sigma} for more details.
}
\examples{
testdata_poisson <- simulate_cosinor(100,
  n_period = 2,
  mesor = 7,
  amp = c(0.1, 0.5),
  acro = c(1, 1),
  beta.mesor = 4.4,
  beta.amp = c(0.1, 0.46),
  beta.acro = c(0.5, -1.5),
  family = "poisson",
  period = c(12, 6),
  n_components = 2,
  beta.group = TRUE
)

mod <- cosinor_model <- cglmm(
  Y ~ group + amp_acro(times,
    period = c(12, 6),
    n_components = 2,
    group = "group"
  ),
  data = testdata_poisson,
  family = glmmTMB::nbinom1()
)
sigma(mod)
}
