% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggpairs.R
\name{ggpairs}
\alias{ggpairs}
\title{ggpairs - A ggplot2 generalized pairs plot}
\usage{
ggpairs(data, mapping = NULL, columns = 1:ncol(data), title = "",
  upper = list(continuous = "cor", combo = "box", discrete = "facetbar", na =
  "na"), lower = list(continuous = "points", combo = "facethist", discrete =
  "facetbar", na = "na"), diag = list(continuous = "densityDiag", discrete =
  "barDiag", na = "naDiag"), params = NULL, ..., axisLabels = c("show",
  "internal", "none"), columnLabels = colnames(data[columns]),
  showStrips = NULL, legends = FALSE, verbose = NULL)
}
\arguments{
\item{data}{data set using.  Can have both numerical and categorical data.}

\item{mapping}{aesthetic mapping (besides \code{x} and \code{y}).  See \code{\link[ggplot2]{aes}()}.  If \code{mapping} is numeric, \code{columns} will be set to the \code{mapping} value and \code{mapping} will be set to \code{NULL}.}

\item{columns}{which columns are used to make plots.  Defaults to all columns.}

\item{title}{title for the graph}

\item{upper}{see Details}

\item{lower}{see Details}

\item{diag}{see Details}

\item{params}{deprecated.  Please see \code{\link{wrap_fn_with_param_arg}}}

\item{...}{deprecated. Please use \code{mapping}}

\item{axisLabels}{either "show" to display axisLabels, "internal" for labels in the diagonal plots, or "none" for no axis labels}

\item{columnLabels}{label names to be displayed.  Defaults to names of columns being used.}

\item{showStrips}{boolean to determine if each plot's strips should be displayed. \code{NULL} will default to the top and right side plots only. \code{TRUE} or \code{FALSE} will turn all strips on or off respectively.}

\item{legends}{boolean to determine the printing of the legend in each plot. Not recommended.}

\item{verbose}{deprecated}
}
\value{
ggpair object that if called, will print
}
\description{
Make a matrix of plots with a given data set
}
\details{
\code{upper} and \code{lower} are lists that may contain the variables
'continuous', 'combo', 'discrete', and 'na'. Each element of the list may be a function or a string.  If a string is supplied, it must implement one of the following options:
\describe{
 \item{continuous}{exactly one of ('points', 'smooth', 'smooth_loess', 'density', 'cor', 'blank'). This option is used for continuous X and Y data.}
 \item{combo}{exactly one of ('box', 'dot', 'facethist', 'facetdensity', 'denstrip', 'blank'). This option is used for either continuous X and categorical Y data or categorical X and continuous Y data.}
 \item{discrete}{exactly one of ('facetbar', 'ratio', 'blank'). This option is used for categorical X and Y data.}
 \item{na}{exactly one of ('na', 'blank').  This option is used when all X data is \code{NA}, all Y data is \code{NA}, or either all X or Y data is \code{NA}.}
}

\code{diag} is a list that may only contain the variables 'continuous', 'discrete', and 'na'. Each element of the diag list is a string implementing the following options:
\describe{
 \item{continuous}{exactly one of ('densityDiag', 'barDiag', 'blankDiag'). This option is used for continuous X data.}
 \item{discrete}{exactly one of ('barDiag', 'blankDiag'). This option is used for categorical X and Y data.}
 \item{na}{exactly one of ('naDiag', 'blankDiag').  This option is used when all X data is \code{NA}.}
}

If 'blank' is ever chosen as an option, then ggpairs will produce an empty plot.

If a function is supplied as an option to \code{upper}, \code{lower}, or \code{diag}, it should implement the function api of \code{function(data, mapping, ...){#make ggplot2 plot}}.  If a specific function needs its parameters set, \code{\link{wrap}(fn, param1 = val1, param2 = val2)} the function with its parameters.
}
\examples{
 # small function to display plots only if it's interactive
p_ <- function(pm) {
  if (interactive()) {
    print(pm)
  }
  invisible()
}

data(tips, package = "reshape")
pm <- ggpairs(tips[, 1:3])
p_(pm)
pm <- ggpairs(tips, 1:3, columnLabels = c("Total Bill", "Tip", "Sex"))
p_(pm)
pm <- ggpairs(tips, upper = "blank")
p_(pm)


# Custom Example
pm <- ggpairs(
  tips[, c(1, 3, 4, 2)],
  upper = list(continuous = "density", combo = "box"),
  lower = list(continuous = "points", combo = "dot")
)
p_(pm)

# Use sample of the diamonds data
data(diamonds, package="ggplot2")
diamonds.samp <- diamonds[sample(1:dim(diamonds)[1], 200), ]

# Custom Example
pm <- ggpairs(
 diamonds.samp[, 1:5],
 mapping = ggplot2::aes(color = cut),
 upper = list(continuous = wrap("density", alpha = 0.5), combo = "box"),
 lower = list(continuous = wrap("points", alpha = 0.3), combo = wrap("dot", alpha = 0.4)),
 title = "Diamonds"
)
p_(pm)

# Only Variable Labels on the diagonal (no axis labels)
pm <- ggpairs(tips[, 1:3], axisLabels="internal")
p_(pm)
# Only Variable Labels on the outside (no axis labels)
pm <- ggpairs(tips[, 1:3], axisLabels="none")
p_(pm)

# Custom Examples
custom_car <- ggpairs(mtcars[, c("mpg", "wt", "cyl")], upper = "blank", title = "Custom Example")
# ggplot example taken from example(geom_text)
  plot <- ggplot2::ggplot(mtcars, ggplot2::aes(x=wt, y=mpg, label=rownames(mtcars)))
  plot <- plot +
    ggplot2::geom_text(ggplot2::aes(colour=factor(cyl)), size = 3) +
    ggplot2::scale_colour_discrete(l=40)
custom_car[1, 2] <- plot
personal_plot <- ggally_text(
  "ggpairs allows you\\nto put in your\\nown plot.\\nLike that one.\\n <---"
)
custom_car[1, 3] <- personal_plot
p_(custom_car)
}
\author{
Barret Schloerke \email{schloerke@gmail.com}, Jason Crowley \email{crowley.jason.s@gmail.com}, Di Cook \email{dicook@iastate.edu}, Heike Hofmann \email{hofmann@iastate.edu}, Hadley Wickham \email{h.wickham@gmail.com}
}
\references{
John W Emerson, Walton A Green, Barret Schloerke, Jason Crowley, Dianne Cook, Heike Hofmann, Hadley Wickham. The Generalized Pairs Plot. Journal of Computational and Graphical Statistics, vol. 22, no. 1, pp. 79-91, 2012.
}
\seealso{
wrap
}
\keyword{hplot}

