% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg-plots.R
\name{ggally_smooth}
\alias{ggally_smooth}
\title{Plots the Scatter Plot with Smoothing}
\usage{
ggally_smooth(data, mapping, ..., method = "lm")
}
\arguments{
\item{data}{data set using}

\item{mapping}{aesthetics being used}

\item{...}{other arguments to add to geom_point}

\item{method}{\code{method} parameter supplied to \code{\link[ggplot2]{geom_smooth}}}
}
\description{
Add a smoothed condition mean with a given scatter plot.
}
\examples{
 data(tips, package = "reshape")
 ggally_smooth(tips, mapping = ggplot2::aes(x = total_bill, y = tip))
 ggally_smooth(tips, mapping = ggplot2::aes_string(x = "total_bill", y = "tip"))
 ggally_smooth(tips, mapping = ggplot2::aes_string(x = "total_bill", y = "tip", color = "sex"))
}
\author{
Barret Schloerke \email{schloerke@gmail.com}
}
\keyword{hplot}

