% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{asd_ocd}
\alias{asd_ocd}
\title{Data: Autism and Obssesive Compulsive Disorder}
\format{
A correlation matrix including 17 variables. These data were measured on a 4 level likert scale.
}
\usage{
data("asd_ocd")
}
\description{
A correlation matrix with 17 variables in total (autsim: 9; OCD: 8).
The sample size was 213.
}
\details{
\strong{Autism}:

\itemize{

  \item \code{CI}  Circumscribed interests
  \item \code{UP}  Unusual preoccupations
  \item \code{RO}  Repetitive use of objects or interests in parts of objects
  \item \code{CR}  Compulsions and/or rituals
  \item \code{CI}  Unusual sensory interests
  \item \code{SM}  Complex mannerisms or stereotyped body movements
  \item \code{SU}  Stereotyped utterances/delayed echolalia
  \item \code{NIL} Neologisms and/or idiosyncratic language
  \item \code{VR}  Verbal rituals
}

\strong{OCD}

\itemize{
  \item \code{CD} Concern with things touched due to dirt/bacteria
  \item \code{TB} Thoughts of doing something bad around others
  \item \code{CT} Continual thoughts that do not go away
  \item \code{HP} Belief that someone/higher power put reoccurring thoughts in their head
  \item \code{CW} Continual washing
  \item \code{CCh} Continual checking CntCheck
  \item \code{CC} Continual counting/repeating
  \item \code{RD} Repeatedly do things until it feels good or just right

}
}
\examples{
data("asd_ocd")

# generate continuous
Y <- MASS::mvrnorm(n = 213,
                   mu = rep(0, 17),
                   Sigma = asd_ocd,
                   empirical = TRUE)


}
\references{
Jones, P. J., Ma, R., & McNally, R. J. (2019). Bridge centrality:
A network approach
to understanding comorbidity. Multivariate behavioral research, 1-15.

Ruzzano, L., Borsboom, D., & Geurts, H. M. (2015).
Repetitive behaviors in autism and obsessive-compulsive
disorder: New perspectives from a network analysis.
Journal of Autism and Developmental Disorders, 45(1),
192-202. doi:10.1007/s10803-014-2204-9
}
\keyword{datasets}
