% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmncv.R
\name{plot.ggmncv}
\alias{plot.ggmncv}
\title{Plot \code{ggmncv} Objects}
\usage{
\method{plot}{ggmncv}(x, size = 1, alpha = 0.5, ...)
}
\arguments{
\item{x}{An object of class \code{ggmncv}}

\item{size}{Numeric. The size of the points (\code{eip}).}

\item{alpha}{Numeric. The transparency of the lines. Only for the solution path options.}

\item{...}{Currently ignored.}
}
\value{
A \code{ggplot} object
}
\description{
Plot the solution path for the partial correlations.
}
\examples{

# data
Y <- GGMncv::ptsd[,1:10]

# correlations
S <- cor(Y, method = "spearman")

# fit model
fit <- ggmncv(R = S, n = nrow(Y))

# plot
plot(fit)

}
