% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htf.R
\name{constrained}
\alias{constrained}
\title{Constrained Precision Matrix}
\usage{
constrained(Sigma, adj)
}
\arguments{
\item{Sigma}{Covariance matrix}

\item{adj}{Matrix with contraints. A one indicates that element
should be constrained to zero.}
}
\value{
A list containing the inverse covariance matrix and the covariance matrix.
}
\description{
Compute the maximum likelihood estimate, given certain elements are constrained to zero
(e.g., an adjacency matrix). This approach is described in \insertCite{hastie2015statistical;textual}{GGMncv}.
}
\note{
The algorithm is written in \code{c++}.
}
\examples{
\donttest{
# data
Y <- GGMncv::ptsd[,1:5]

# columns
p <- ncol(Y)

# contstraint matrix
constraints <- matrix(0,p,p)

# set one value to zero
constraints[2,3] <- 1
constraints[3,2] <-1

# estimate, given constraints
fit <- constrained(cor(Y), adj = constraints)
Theta <- fit$Theta
}
}
