g.part3 = function(metadatadir=c(),f0,f1,anglethreshold = 5,timethreshold = 5, 
                   acc.metric="ENMO", ignorenonwear=TRUE, overwrite=FALSE, desiredtz="Europe/London",
                   constrain2range=TRUE,do.part3.pdf=TRUE, do.parallel = TRUE) {
  # description: function to apply sleep detection functions to milestone data generated by g.part1
  #------------------------------------
  # create output directory if it does not exist
  if (file.exists(paste(metadatadir,sep=""))) {
  } else {
    dir.create(file.path(metadatadir))
  }
  if (file.exists(paste(metadatadir,"/meta/ms3.out",sep=""))) {
  } else {
    dir.create(file.path(paste(metadatadir,"/meta",sep=""),"ms3.out"))
    dir.create(file.path(paste(metadatadir,"/meta",sep=""),"sleep.qc"))
  }
  #------------------------------------------------------
  fnames  =dir(paste(metadatadir,"/meta/basic",sep=""))
  if (f1 > length(fnames) | f1 == 0) f1 = length(fnames)
  if (f0 > length(fnames) | f0 == 0) f0 = 1
  #========================================================================
  # check which files have already been processed, such that no double work is done
  # ffdone a matrix with all the binary filenames that have been processed
  ffdone = fdone = dir(paste(metadatadir,"/meta/ms3.out",sep=""))
  if (length(fdone) > 0) {
    for (ij in 1:length(fdone)) {
      tmp = unlist(strsplit(fdone[ij],".RData"))
      ffdone[ij] = tmp[1]
    }
  } else {
    ffdone = c()
  }
  nightsperpage =7
  
  
  if (do.parallel == TRUE) {
    closeAllConnections() # in case there is a still something running from last time, kill it.
    cores=parallel::detectCores()
    Ncores = cores[1]
    if (Ncores > 3) {
      cl <- parallel::makeCluster(Ncores-1) #not to overload your computer
      doParallel::registerDoParallel(cl)
    } else {
      cat(paste0("\nparallel processing not possible because number of available cores (",Ncores,") < 4"))
      do.parallel = FALSE
    }
  }
  t1 = Sys.time() # copied here
  if (do.parallel == TRUE) {
    cat(paste0('\n Busy processing ... see ', metadatadir,'/ms3', ' for progress\n'))
  }
  # check whether we are indevelopment mode:
  GGIRinstalled = is.element('GGIR', installed.packages()[,1])
  packages2passon = functions2passon = NULL
  GGIRloaded = "GGIR" %in% .packages()
  if (GGIRloaded) { #pass on package
    packages2passon = 'GGIR'
  } else { # pass on functions
    functions2passon = c("g.sib.det", "g.detecmidnight", "iso8601chartime2POSIX", "g.sib.plot", "g.sib.sum")
  }
  fe_dopar = foreach::`%dopar%`
  fe_do = foreach::`%do%`
  i = 0 # declare i because foreach uses it, without declaring it
  `%myinfix%` = ifelse(do.parallel, fe_dopar, fe_do) # thanks to https://stackoverflow.com/questions/43733271/how-to-switch-programmatically-between-do-and-dopar-in-foreach
  output_list =foreach::foreach(i=f0:f1, .packages = packages2passon, 
                                .export=functions2passon, .errorhandling='pass') %myinfix% { 
    tryCatchResult = tryCatch({
      # for (i in f0:f1) {
      FI = file.info(paste(metadatadir,"/meta/basic/",fnames[i],sep=""))
      if (is.na(FI$size) == TRUE) FI$size = 0
      if (FI$size == 0 | is.na(FI$size) == TRUE | length(FI$size) == 0) {
        cat(paste("P3 file ",fnames[i],sep=""))
        cat("Filename not recognised")
      }
      fname = unlist(strsplit(fnames[i],".RData"))[1]
      fname = unlist(strsplit(fname,"eta_"))[2]
      #=========================================================
      #check whether file has already been processed
      #by comparing filename to read with list of processed files
      if (length(ffdone) > 0) {
        if (length(which(ffdone == fname)) > 0) { 
          skip = 1 #skip this file because it was analysed before")
        } else {
          skip = 0 #do not skip this file
        }
      } else {
        skip = 0
      }
      if (overwrite == TRUE) skip = 0
      if (skip == 0) {  
        # Load previously stored meta-data from part1.R
        cat(paste(" ",i,sep=""))
        IMP = M = c()
        load(paste(metadatadir,"/meta/basic/",fnames[i],sep=""))
        load(paste(metadatadir,"/meta/ms2.out/",unlist(strsplit(fnames[i], "eta_"))[2],sep=""))
        if (M$filecorrupt == FALSE & M$filetooshort == FALSE) {
          # IMP = g.impute(M,I,strategy=1,hrs.del.start=0,hrs.del.end=0,maxdur=0)
          SLE = g.sib.det(M,IMP,I,twd=c(-12,12),timethreshold=timethreshold,anglethreshold=anglethreshold,
                          acc.metric=acc.metric,desiredtz=desiredtz,constrain2range=constrain2range)
          L5list = SLE$L5list
          sptwindow_HDCZA_end = SLE$sptwindow_HDCZA_end
          sptwindow_HDCZA_start = SLE$sptwindow_HDCZA_start
          tib.threshold = SLE$tib.threshold
          if (length(SLE$output) > 0 & SLE$detection.failed == FALSE) {
            id = as.character(unlist(strsplit(I$filename,"_"))[1])
            datename = as.character(unlist(strsplit(as.character(as.matrix(M$metashort[1]))," "))[1])
            plottitle = " " #datename#"blablbalbal"# paste("File: ",i," | date: ",datename," | filename: ",fna2," | night: ",j,sep="")
            if (do.part3.pdf == TRUE) {
              pdf(paste(metadatadir,"/meta/sleep.qc/graphperday_id_",id,"_",I$filename,".pdf",sep=""),width=8.2,height=11.7)
              g.sib.plot(SLE,M,I,plottitle,nightsperpage=nightsperpage)
              dev.off()
            }
            sib.cla.sum = c()
            sib.cla.sum = g.sib.sum(SLE,M,ignorenonwear=ignorenonwear,desiredtz=desiredtz)
            save(sib.cla.sum,L5list,sptwindow_HDCZA_end, sptwindow_HDCZA_start, tib.threshold, 
                 file=paste(metadatadir,"/meta/ms3.out/",fname,".RData",sep=""))
          }
        }
      }
    }) # END tryCatch
    
    return(tryCatchResult) 
  }
  if (do.parallel == TRUE) {
    on.exit(parallel::stopCluster(cl))
    for (oli in 1:length(output_list)) { # logged error and warning messages
      if (is.null(unlist(output_list[oli])) == FALSE) {
        cat(paste0("\nErrors and warnings for ",fnames[oli]))
        print(unlist(output_list[oli])) # print any error and warnings observed
      }
    }
  }
  # SI = sessionInfo()
  # save(SI,file=paste(metadatadir,"/results/QC/sessioninfo_part3.RData",sep=""))
  SI = sessionInfo() 
  sessionInfoFile = paste(metadatadir,"/results/QC/sessioninfo_part3.RData",sep="")
  if (file.exists(sessionInfoFile)) {
    FI = file.info(sessionInfoFile)
    timesincecreation = abs(as.numeric(difftime(FI$ctime,Sys.time(),units="secs")))
    # if file is older than 2 hours plus a random number of seconds (max 1 hours) then overwrite it
    if (timesincecreation > (2*3600 + (sample(seq(1,3600,by=0.1),size = 1)))) {
      save(SI,file=sessionInfoFile)
    }
  } else {
    save(SI,file=sessionInfoFile)
  }
}
