% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_central_region.R
\name{geom_central_region}
\alias{geom_central_region}
\alias{stat_central_region}
\title{Central region plot}
\usage{
geom_central_region(
  mapping = NULL,
  data = NULL,
  stat = "CentralRegion",
  position = "identity",
  ...,
  coverage = 0.5,
  type = "erl",
  filled = TRUE,
  drawcenterline = TRUE,
  colours = grey.colors(length(coverage), start = 0.9, end = 0.5),
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_central_region(
  mapping = NULL,
  data = NULL,
  position = "identity",
  ...,
  coverage = 0.5,
  type = "erl",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{coverage}{A number between 0 and 1. The 100*coverage\% central region will be calculated.
A vector of values can also be provided, leading to the corresponding number of central regions.}

\item{type}{The options and details for \code{type} are given in \code{\link{central_region}}.}

\item{filled}{Boolean. Should the ribbon be filled?}

\item{drawcenterline}{Boolean. Should the center line be drawn?}

\item{colours}{Colours for different coverage levels}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\description{
\code{geom_central_region} and \code{stat_central_region} can be used to compute
and plot \code{central_region} from data arranged in a \code{data.frame}.
}
\details{
Plots of central regions (global envelopes) with the specified \code{coverage}
and \code{type} (see \code{\link{central_region}}).
When splitting the set of functions to groups by aesthetics or facets, see
examples, the central regions are constructed separately for each group,
each having the specified \code{coverage}.

If Nfunc*(1-coverage) < 1, where Nfunc is the number of functions/curves,
the curves are plotted instead of any region.
}
\section{Aesthetics}{

\code{geom_central_region} requires \code{x}, \code{y} and \code{curveid}.
Additionally \code{geom_central_region} uses the same aesthetics as
\code{\link{geom_ribbon}} if \code{filled==TRUE} and
\code{\link{geom_line}} otherwise.
For multiple coverage values additional aesthetics are not currently supported.
}

\section{Computed variables}{

\code{stat_central_region} computes
\code{after_stat(ymax)} and \code{after_stat(ymin)} for the high and low value of the central region.

For multiple coverages the variables use the same names as \code{\link{central_region}},
i.e. \code{hi.95} and \code{lo.95} for the region with 95% coverage.
}

\examples{
require("ggplot2")
## Generate some data
#------------------------------------------------------
# Simulate regression data according to the cubic model
# f(x) = 0.8x - 1.8x^2 + 1.05x^3 for x in [0,1]
par <- c(0,0.8,-1.8,1.05) # Parameters of the true polynomial model
res <- 100 # Resolution
x <- seq(0, 1, by=1/res); x2=x^2; x3=x^3;

f <- par[1] + par[2]*x + par[3]*x^2 + par[4]*x^3 # The true function
d <- f + rnorm(length(x), 0, 0.04) # Data

# Estimate polynomial regression model
reg <- lm(d ~ x + x2 + x3)
ftheta <- reg$fitted.values
resid0 <- reg$residuals

# Bootstrap regression
B <- 200 # Number of bootstrap samples
df <- NULL
for(i in 1:B) {
  u <- sample(resid0, size=length(resid0), replace=TRUE)
  reg1 <- lm((ftheta+u) ~ x + x2 + x3)
  df <- rbind(df, data.frame(y=reg1$fitted.values, x=x, i=i,
    g=ifelse(i<14, "A", "B"), g2=ifelse(i<100, "A", "B")))
}

ggplot(df) + geom_line(aes(x, y, group=i))
ggplot(df) + geom_central_region(aes(x=x, y=y, curveid=i), coverage=0.50)
ggplot(df) + geom_central_region(aes(x=x, y=y, curveid=i), coverage=0.50, filled=FALSE)
# Central regions for two groups as specified by 'g2'
ggplot(df) + geom_central_region(aes(x=x, y=y, curveid=i, col=g2), coverage=0.90, filled=FALSE)
ggplot(df) + geom_central_region(aes(x=x, y=y, curveid=i), coverage=0.90) + facet_wrap(vars(g2))
\dontshow{
# If nr. of functions < 20, then the functions are drawn; otherwise the 100*coverage\% central region
ggplot(df[df$i < 10,]) + geom_central_region(aes(x=x, y=y, curveid=i), coverage=0.90)
# Central regions for two groups split by 'g'; <20 functions in the first group
ggplot(df) + geom_central_region(aes(x=x, y=y, curveid=i, col=g, fill=g), coverage=0.90)
ggplot(df) + geom_central_region(aes(x=x, y=y, curveid=i, col=g), coverage=0.90, filled=FALSE)
}

# Central regions with multiple coverage levels
ggplot(df) + geom_central_region(aes(x=x, y=y, curveid=i), coverage=c(0.2,0.4,0.6)) +
  theme_minimal()
ggplot(df) + geom_central_region(aes(x=x, y=y, curveid=i), coverage=seq(0.1, 0.9, length=20),
  colours=rainbow(20))

# Colors for multiregions are not supported
ggplot(df) + geom_central_region(aes(x=x, y=y+0.1*(g2=="B"),
  curveid=i, col=as.factor(g2)), coverage=c(0.05, 0.2,0.4,0.6))
ggplot(df) + geom_central_region(aes(x=x, y=y, curveid=i),
  coverage=c(0.05, 0.2,0.4,0.6)) + facet_wrap(vars(g2))

# Using stat_central_region with geom_linerange and geom_rect
ggplot(df) +
  geom_linerange(aes(curveid=i, x=x, y=y, ymax=after_stat(ymax), ymin=after_stat(ymin),
               group=g2, col=factor(g2)),
               stat="central_region", coverage = 0.90, position=position_dodge(0.01))
ggplot(within(df, {x = x+0.004*(g2=="B")})) +
  geom_rect(aes(curveid=i, x=x, y=y, xmax=after_stat(x), xmin=after_stat(x+0.004),
              ymax=after_stat(ymax), ymin=after_stat(ymin), group=g2, fill=factor(g2)),
              stat="central_region", coverage = 0.90)
# Non-finite values are not supported
ggplot(within(df, {y = ifelse(runif(length(y)) < 0.001, Inf, y)})) +
  geom_central_region(aes(x=x, y=y, curveid=i))
}
\seealso{
\code{\link{central_region}} for the basic computation and,
\code{\link{geom_ribbon}} for the default base geom.
}
