% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPI_detect.R
\name{detect_transitions}
\alias{detect_transitions}
\title{Detect Transitions}
\usage{
detect_transitions(
  binfile,
  binfile_path,
  output_folder,
  minimum_event_duration = 3,
  x_cpt_penalty = 20,
  y_cpt_penalty = 30,
  z_cpt_penalty = 20,
  CutTime24Hr = "15:00"
)
}
\arguments{
\item{binfile}{Text lines read from an open connection to a bin file.}

\item{binfile_path}{Path to the bin file to be processed.}

\item{output_folder}{Path to the folder containing GENEAcore run outputs and Measurement Period Information (MPI) files.}

\item{minimum_event_duration}{The minimum interval between changepoint transitions.}

\item{x_cpt_penalty}{The manual penalty value applied in the PELT changepoint algorithm for the x axis, see \code{\link[changepoint]{cpt.var}}.}

\item{y_cpt_penalty}{The manual penalty value applied in the PELT changepoint algorithm for the y axis, see \code{\link[changepoint]{cpt.var}}.}

\item{z_cpt_penalty}{The manual penalty value applied in the PELT changepoint algorithm for the z axis, see \code{\link[changepoint]{cpt.var}}.}

\item{CutTime24Hr}{Time in 24h to split the days up by.}
}
\value{
List of time, index and day number of each transition within the measurement period information.
}
\description{
Detect Transitions
}
\details{
Function to detect mean and variance changepoints in 1Hz acceleration data from a bin file.
}
\examples{
binfile_path <- system.file("inst/extdata/20Hz_file.bin", package = "GENEAcore")
con <- file(binfile_path, "r")
binfile <- readLines(con, skipNul = TRUE)
close(con)
output_folder <- "."
MPI <- create_MPI(binfile, binfile_path, output_folder)
MPI <- detect_transitions(binfile, binfile_path, output_folder)
}
