% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.bic.BLMCP.R
\name{predict.bic.BLMCP}
\alias{predict.bic.BLMCP}
\title{Make predictions from a "bic.BLMCP" object.}
\usage{
\method{predict}{bic.BLMCP}(object, newE, newG, ...)
}
\arguments{
\item{object}{Fitted \code{"bic.BLMCP"} object.}

\item{newE}{Matrix of new values for \code{E} at which predictions are to be
made.}

\item{newG}{Matrix of new values for \code{G} at which predictions are to be
made.}

\item{\dots}{Not used. Other arguments to predict.}
}
\value{
The object returned depends on the \dots{} argument which is passed
on to the \code{predict} method for \code{BLMCP} objects.
}
\description{
This function makes predictions from a BIC BLMCP model, using the stored
\code{"bic.BLMCP"} object.  This function makes it easier to use the results of BIC to
make a prediction.
}
\references{
Mengyun Wu, Yangguang Zang, Sanguo Zhang, Jian Huang, and Shuangge Ma.
\emph{Accommodating missingness in environmental measurements in gene-environment interaction
analysis. Genetic Epidemiology, 41(6):523-554, 2017.}

Jin Liu, Jian Huang, Yawei Zhang, Qing Lan, Nathaniel Rothman, Tongzhang Zheng, and
Shuangge Ma.
\emph{Identification of gene-environment interactions in cancer studies using penalization. Genomics, 102(4):189-194, 2013.}\cr
\url{http://europepmc.org/backend/ptpmcrender.fcgi?accid=PMC3869641&blobtype=pdf}
}
\seealso{
\code{coef}, and \code{plot} and
\code{bic.BLMCP} methods, and \code{BLMCP}.
}
