% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.BLMCP.R
\name{predict.BLMCP}
\alias{predict.BLMCP}
\title{Make predictions from a "BLMCP" object}
\usage{
\method{predict}{BLMCP}(object, newE, newG, ...)
}
\arguments{
\item{object}{Fitted \code{"BLMCP"} object.}

\item{newE}{Matrix of new values for \code{E} at which predictions are to be
made.}

\item{newG}{Matrix of new values for \code{G} at which predictions are to be
made.}

\item{\dots}{Not used. Other arguments to predict.}
}
\value{
The object returned depends on the \dots{} argument which is passed
on to the \code{predict} method for \code{BLMCP} objects.
}
\description{
This function makes predictions from a  BLMCP
model, using the stored \code{"BLMCP"} object.
}
\references{
Mengyun Wu, Yangguang Zang, Sanguo Zhang, Jian Huang, and Shuangge Ma.
\emph{Accommodating missingness in environmental measurements in gene-environment interaction
analysis. Genetic Epidemiology, 41(6):523-554, 2017.}\cr  Jin Liu, Jian Huang, Yawei Zhang,
Qing Lan, Nathaniel Rothman, Tongzhang Zheng, and Shuangge Ma.
\emph{Identification of gene-environment interactions in cancer studies using penalization. Genomics, 102(4):189-194, 2013.}
}
\seealso{
\code{BLMCP}, \code{coef}, and \code{plot} methods, and \code{bic.BLMCP} method.
}
