% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makePolicyMeanValue.R
\name{makePolicyMeanValue}
\alias{makePolicyMeanValue}
\title{Make a Mean Value Policy Function}
\usage{
makePolicyMeanValue(span = 200)
}
\arguments{
\item{span}{a positive integer. When the time index is an integer multiple of span,
the mean value policy sets the current prices and supplies to the averages of the previous span-1 periods.}
}
\value{
A mean value policy function.
}
\description{
This function returns a mean value policy function with a given span to accelerate convergence when calculating general equilibrium.
We can observe the number of periods included in the economic cycle of the time series, and then set the number of periods as the parameter (i.e. span) of this function.
See \code{\link{policyMeanValue}}
}
\examples{
\donttest{
## See the function gemDualLinearProgramming.
A <- matrix(c(
  0, 0, 0, 1,
  8, 6, 1, 0,
  4, 2, 1.5, 0,
  2, 1.5, 0.5, 0
), 4, 4, TRUE)
B <- matrix(c(
  60, 30, 20, 0,
  0, 0, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0
), 4, 4, TRUE)
S0Exg <- {
  S0Exg <- matrix(NA, 4, 4)
  S0Exg[2:4, 4] <- c(48, 20, 8)
  S0Exg
}

ge <- sdm2(
  A = A, B = B, S0Exg = S0Exg,
  maxIteration = 1,
  numberOfPeriods = 1000,
  ts = TRUE
)
matplot(ge$ts.q, type = "l")

ge2 <- sdm2(
  A = A, B = B, S0Exg = S0Exg,
  maxIteration = 1,
  numberOfPeriods = 1000,
  ts = TRUE,
  policy = makePolicyMeanValue(150)
)
matplot(ge2$ts.q, type = "l")
}
}
\seealso{
\code{\link{policyMeanValue}}
\code{\link{gemDualLinearProgramming}}.
}
