% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemCanonicalDynamicMacroeconomic_Timeline_2_2.R
\name{gemCanonicalDynamicMacroeconomic_Timeline_2_2}
\alias{gemCanonicalDynamicMacroeconomic_Timeline_2_2}
\title{A Canonical Dynamic Macroeconomic General Equilibrium Model in Timeline Form (see Torres, 2016)}
\usage{
gemCanonicalDynamicMacroeconomic_Timeline_2_2(
  alpha.firm = rep(1, 4),
  es.prod.lab.firm = 1,
  beta.prod.firm = 0.35,
  depreciation.rate = 0.06,
  eis = 1,
  rho.beta = 0.97,
  beta.prod.consumer = 0.4,
  es.prod.lab.consumer = 1,
  gr = 0,
  initial.product.supply = 200,
  head.tail.adjustment = "both",
  wage.payment = "post",
  beta.consumer = NULL,
  ...
)
}
\arguments{
\item{alpha.firm}{a positive vector, indicating the efficiency parameters of the firm for each economic period.
The number of economic periods will be set to length(alpha.firm) + 1.}

\item{es.prod.lab.firm}{the elasticity of substitution between product and labor in the production function of the firm.}

\item{beta.prod.firm}{the share parameter of the product in the production function.}

\item{depreciation.rate}{the physical depreciation rate of capital stock.}

\item{eis}{a positive scalar indicating the elasticity of intertemporal substitution of the consumer.}

\item{rho.beta}{the subjective discount factor of the consumer.}

\item{beta.prod.consumer}{the share parameter of the product in the period utility function.}

\item{es.prod.lab.consumer}{the elasticity of substitution between product and labor in the CES-type period utility function of the consumer.}

\item{gr}{the growth rate of the labor supply.}

\item{initial.product.supply}{the initial product supply.}

\item{head.tail.adjustment}{a character string specifying the type of the head-tail-adjustment policy, must be one of "both" (default), "head", "tail" or "none".}

\item{wage.payment}{a character string specifying the wage payment method, must be one of "pre" or "post".}

\item{beta.consumer}{NULL (the default) or a positive vector containing length(alpha.firm) + 1 elements specifying the consumer's intertemporal share parameter.
If beta.consumer is not NULL, rho.beta will be ignored.}

\item{...}{arguments to be passed to the function sdm2.}
}
\description{
A canonical dynamic macroeconomic general equilibrium model in timeline form (see Torres, 2016, Table 2.1 and 2.2).
The firm has a CESAK production function.
}
\examples{
\donttest{
#### Take the wage postpayment assumption.
ge <- gemCanonicalDynamicMacroeconomic_Timeline_2_2()
np <- 5
eis <- 1
rho.beta <- 0.97
gr <- 0
ge$p
ge$p[1:(np - 1)] / ge$p[2:np] - 1
ge$p[(np + 1):(2 * np - 2)] / ge$p[(np + 2):(2 * np - 1)] - 1
sserr(eis = eis, rho.beta = rho.beta, gr = gr) # the steady-state equilibrium return rate
ge$z
ge$D
node_plot(ge$dst.consumer, TRUE)

#### Take the wage postpayment assumption.
eis <- 0.8
rho.beta <- 0.97
gr <- 0.03
ge <- gemCanonicalDynamicMacroeconomic_Timeline_2_2(
  es.prod.lab.firm = 0.8,
  eis = eis, rho.beta = rho.beta, es.prod.lab.consumer = 0.8,
  gr = gr
)

np <- 5
ge$p
growth_rate(ge$p[1:np])
1 / (1 + sserr(eis = eis, rho.beta = rho.beta, gr = gr)) - 1
ge$z
growth_rate(ge$z[1:(np - 1)])
ge$D
ge$S

##### a fully anticipated technology shock.
## Warning: Running the program below takes several minutes.
# np <- 120
# alpha.firm <- rep(1, np - 1)
# alpha.firm[40] <- 1.05
# ge <- gemCanonicalDynamicMacroeconomic_Timeline_2_2(alpha.firm = alpha.firm)
#
## The steady state product supply is 343.92.
## the (economic) time series of product supply.
# plot(ge$z[1:(np - 1)] / 343.92 - 1, type = "o", pch = 20)
## The steady state product consumption is 57.27.
## the (economic) time series of product consumption.
# plot(ge$D[2:(np - 1), np] / 57.27 - 1, type = "o", pch = 20)
# plot(growth_rate(ge$p[1:(np)]), type = "o", pch = 20)
# plot(growth_rate(ge$p[(np + 1):(2 * np)]), type = "o", pch = 20)
#
##### an unanticipated technology shock.
# np <- 50
# alpha.firm <- rep(1, np - 1)
# alpha.firm[1] <- 1.05
# ge <- gemCanonicalDynamicMacroeconomic_Timeline_2_2(
#   alpha.firm = alpha.firm,
#   initial.product.supply = 286.6341, # the steady state value
#   head.tail.adjustment = "tail"
# )
#
## The steady state product supply is 343.92.
## the (economic) time series of product supply.
# plot(ge$z[1:(np - 1)] / 343.92 - 1, type = "o", pch = 20)
## The steady state product consumption is 57.27.
## the (economic) time series of product consumption.
# plot(ge$D[2:(np - 1), np] / 57.27 - 1, type = "o", pch = 20)
# plot(growth_rate(ge$p[1:(np)]), type = "o", pch = 20)
# plot(growth_rate(ge$p[(np + 1):(2 * np)]), type = "o", pch = 20)
#
### a technology shock anticipated several periods in advance.
# np <- 50
# alpha.firm <- rep(1, np - 1)
# alpha.firm[5] <- 1.05
# ge5 <- gemCanonicalDynamicMacroeconomic_Timeline_2_2(
#   alpha.firm = alpha.firm,
#   initial.product.supply = 286.6341, # the steady state value
#   head.tail.adjustment = "tail"
# )
#
## The steady state product supply is 343.92.
## the (economic) time series of product supply
# plot(ge5$z[1:(np - 1)] / 343.92 - 1, type = "o", pch = 20)
## The steady state product consumption is 57.27.
## the (economic) time series of product consumption
# plot(ge5$D[2:(np - 1), np] / 57.27 - 1, type = "o", pch = 20)
# plot(growth_rate(ge5$p[1:(np)]), type = "o", pch = 20)
# plot(growth_rate(ge5$p[(np + 1):(2 * np)]), type = "o", pch = 20)
#
# alpha.firm <- rep(1, np - 1)
# alpha.firm[10] <- 1.05
# ge10 <- gemCanonicalDynamicMacroeconomic_Timeline_2_2(
#   alpha.firm = alpha.firm,
#   initial.product.supply = 286.6341, # the steady state value
#   head.tail.adjustment = "tail"
# )
# plot(ge$z[1:(np - 1)] / 343.92 - 1, type = "o", pch = 20, ylim = c(-0.005, 0.017))
# lines(ge5$z[1:(np - 1)] / 343.92 - 1, type = "o", pch = 21)
# lines(ge10$z[1:(np - 1)] / 343.92 - 1, type = "o", pch = 22)

##### an unanticipated technology shock.
## Warning: Running the program below takes several minutes.
# np <- 100
# alpha.firm <- exp(0.01)
# for (t in 2:(np - 1)) {
#   alpha.firm[t] <- exp(0.9 * log(alpha.firm[t - 1]))
# }
# plot(alpha.firm)
#
# ge <- gemCanonicalDynamicMacroeconomic_Timeline_2_2(
#   alpha.firm = alpha.firm,
#   initial.product.supply = 286.6341, # the steady state value
#   head.tail.adjustment = "tail"
# )
#
## The steady state product supply is 343.92.
## the (economic) time series of product supply
# plot(ge$z[1:(np - 1)] / 343.92 - 1, type = "o", pch = 20)
## The steady state product consumption is 57.27.
## the (economic) time series of product consumption
# plot(ge$D[2:(np - 1), np] / 57.27 - 1, type = "o", pch = 20)
# plot(growth_rate(ge$p[1:(np)]), type = "o", pch = 20)
# plot(growth_rate(ge$p[(np + 1):(2 * np)]), type = "o", pch = 20)

#### Take the wage prepayment assumption.
ge <- gemCanonicalDynamicMacroeconomic_Timeline_2_2(wage.payment = "pre")
np <- 5
eis <- 1
rho.beta <- 0.97
gr <- 0
ge$p
ge$p[1:(np - 1)] / ge$p[2:np] - 1
ge$p[(np + 1):(2 * np - 2)] / ge$p[(np + 2):(2 * np - 1)] - 1
sserr(eis = eis, rho.beta = rho.beta, gr = gr) # the steady-state equilibrium return rate
ge$z
ge$D
node_plot(ge$dst.consumer, TRUE)

#### Take the wage prepayment assumption.
np <- 5
eis <- 0.8
rho.beta <- 0.97
gr <- 0.03
ge <- gemCanonicalDynamicMacroeconomic_Timeline_2_2(
  es.prod.lab.firm = 0.8,
  eis = eis, rho.beta = rho.beta, es.prod.lab.consumer = 0.8,
  gr = gr,
  wage.payment = "pre"
)

ge$p
growth_rate(ge$p[1:np])
1 / (1 + sserr(eis = eis, rho.beta = rho.beta, gr = gr)) - 1
ge$z
growth_rate(ge$z[1:(np - 1)])
ge$D
ge$S
}

}
\references{
Torres, Jose L. (2016, ISBN: 9781622730452) Introduction to Dynamic Macroeconomic General Equilibrium Models (Second Edition). Vernon Press.
}
\seealso{
\code{\link{gemCanonicalDynamicMacroeconomic_TimeCircle_2_2}},\cr
\code{\link{gemCanonicalDynamicMacroeconomic_Sequential_3_2}},\cr
\code{\link{gemCanonicalDynamicMacroeconomic_Sequential_WagePostpayment_4_3}}.
}
