% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemTwoCountry_Tariff_9_5.R
\name{gemTwoCountry_Tariff_9_5}
\alias{gemTwoCountry_Tariff_9_5}
\title{An Example of Two-Country Economy with Tariff}
\usage{
gemTwoCountry_Tariff_9_5(...)
}
\arguments{
\item{...}{arguments to be passed to the function sdm2.}
}
\value{
A general equilibrium.
}
\description{
A general equilibrium example of two-country economy with tariff.
}
\examples{
\donttest{
es.DFProd <- 0.8 # substitution elasticity between domestic and foreign products
es.CL <- 0.8 # substitution elasticity between capital and labor

dst.firm.CHN <- node_new("output",
  type = "SCES", alpha = 1, beta = c(0.78, 0.22), es = es.CL,
  "lab.CHN", "cap.CHN"
)

dst.household.CHN <- node_new("util",
  type = "FIN", rate = c(1, outbound.investment.rate = 0.028),
  "cc1", "bond.ROW"
)

node_set(dst.household.CHN, "cc1",
  type = "SCES", alpha = 1, beta = c(0.93, 0.07), es = es.DFProd,
  "prod.CHN", "imported.prod.CHN"
)

node_plot(dst.household.CHN)

dst.foreign.trade.CHN <- node_new("imported.product",
  type = "FIN",
  rate = c(1, 0.016),
  "prod.ROW", "tariff.CHN"
)

dst.firm.ROW <- node_new("output",
  type = "SCES", alpha = 1, beta = c(0.75, 0.25), es = es.CL,
  "lab.ROW", "cap.ROW"
)

dst.household.ROW <- node_new("util",
  type = "SCES", alpha = 1, beta = c(0.02, 0.98), es = es.DFProd,
  "prod.CHN", "prod.ROW"
)

dstl <- list(
  dst.firm.CHN, dst.household.CHN, dst.foreign.trade.CHN,
  dst.firm.ROW, dst.household.ROW
)

ge <- sdm2(dstl,
  names.commodity = c(
    "prod.CHN", "lab.CHN", "cap.CHN", "imported.prod.CHN", "tariff.CHN",
    "prod.ROW", "lab.ROW", "cap.ROW", "bond.ROW"
  ),
  names.agent = c(
    "firm.CHN", "household.CHN", "foreign.trade.CHN",
    "firm.ROW", "household.ROW"
  ),
  B = {
    tmp <- matrix(0, 9, 5, TRUE)
    tmp[1, 1] <- tmp[6, 4] <- 1
    tmp[4, 3] <- 1
    tmp
  },
  S0Exg = {
    tmp <- matrix(NA, 9, 5, TRUE)
    tmp[2, 2] <- 53 # the supply of lab.CHN
    tmp[3, 2] <- 15 # the supply of cap.CHN
    tmp[5, 2] <- 0.29 # the supply of tariff.CHN
    tmp[7, 5] <- 240 # the supply of lab.ROW
    tmp[8, 5] <- 77 # the supply of cap.ROW
    tmp[9, 5] <- 2 # the supply of bond.ROW
    tmp
  },
  numeraire = "lab.CHN"
)

ge$p
ge$z
}
}
\seealso{
\cite{\link{gemTwoCountry_Bond_7_4}}
}
