% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DCES.R
\name{DCES}
\alias{DCES}
\alias{DCES_demand}
\alias{DCES_compensated_demand}
\title{Displaced CES Utility Function and Displaced CES Demand Function}
\usage{
DCES(es, beta, xi, x)

DCES_demand(es, beta, xi, w, p)

DCES_compensated_demand(es, beta, xi, u, p)
}
\arguments{
\item{es}{the elasticity of substitution.}

\item{beta}{a n-vector consisting of the marginal expenditure share coefficients.}

\item{xi}{a n-vector. Each element of xi parameterizes whether
the particular good is a necessity for the household (Acemoglu, 2009, page 152).
For example, xi[i] > 0 may mean that the household needs to consume at least a certain amount of good i to survive.}

\item{x}{a n-vector consisting of the inputs.}

\item{w}{a scalar indicating the income.}

\item{p}{a n-vector indicating the prices.}

\item{u}{a scalar indicating the utility level.}
}
\description{
Compute the displaced CES utility function and the displaced CES demand function (Fullerton, 1989).
}
\section{Functions}{
\itemize{
\item \code{DCES}: Compute the displaced CES utility function (Fullerton, 1989),
e.g. (beta_1 ^ (1 / es) * (x_1 - xi_1) ^ (1 - 1 / es) +
beta_2 ^ (1 / es) * (x_2 - xi_2) ^ (1 - 1 / es)) ^ (es / (es - 1)
wherein beta1 + beta2 == 1.

When es==1, the DCES utility function becomes the Stone-Geary utility function.

\item \code{DCES_demand}: Compute the displaced CES demand (Fullerton, 1989).

\item \code{DCES_compensated_demand}: Compute the displaced CES compensated demand (Fullerton, 1989).
}}

\examples{
\donttest{
es <- 0.99
beta <- prop.table(1:5)
xi <- 0
w <- 500
p <- 2:6

x <- DCES_demand (
  es = es,
  beta = beta,
  xi = xi,
  w = w,
  p = p
)

u <- DCES(es = es,
          beta = beta,
          xi = xi,
          x = x)

SCES(es = es,
     alpha = 1,
     beta = beta,
     x = x)

DCES_compensated_demand(
  es = es,
  beta = beta,
  xi = xi,
  u = u,
  p = p
)

DCES_compensated_demand(
  es = es,
  beta = beta,
  xi = seq(10, 50, 10),
  u = u,
  p = p
)
}
}
\references{
Acemoglu, D. (2009, ISBN: 9780691132921) Introduction to Modern Economic Growth. Princeton University Press.

Fullerton, D. (1989) Notes on Displaced CES Functional Forms. Available at: https://works.bepress.com/don_fullerton/39/
}
