% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optidisc.R
\name{optidisc}
\alias{optidisc}
\alias{print.optidisc}
\alias{plot.optidisc}
\title{Optimal discretization for continuous variables and visualization}
\usage{
optidisc(y = y, x = x, discmethod = discmethod, discitv = discitv)
\\method{print}{optidisc}(result)
\\method{plot}{optidisc}(result)
}
\arguments{
\item{y}{A numeric vector of response variable}

\item{x}{A numeric vector of explanatory variable}

\item{discmethod}{A character vector of discretization methods}

\item{discitv}{A numeric vector of numbers of intervals}

\item{result}{A list of \code{optidisc} result}
}
\description{
Optimal discretization for continuous variables and visualization
}
\examples{
## set optional discretization methods and numbers of intervals
# optional methods: equal, natural, quantile, geometric, sd and manual
discmethod <- c("equal","natural","quantile","geometric","sd")
discitv <- c(3:7)
## optimal discretization
odc1 <- optidisc(ndvi_40$NDVIchange, ndvi_40$Tempchange, discmethod, discitv)
# odc1
# plot(odc1)
# plot(odc1$discretization)

}
