% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisson_GAGA.R
\name{poisson_GAGA}
\alias{poisson_GAGA}
\title{Fit a Poisson model via the GAGA algorithm}
\usage{
poisson_GAGA(
  X,
  y,
  alpha = 1,
  itrNum = 30,
  thresh = 0.001,
  flag = TRUE,
  lamda_0 = 0.5,
  fdiag = TRUE,
  subItrNum = 20
)
}
\arguments{
\item{X}{Input matrix, of dimension nobs*nvars; each row is an observation.
If the intercept term needs to be considered in the estimation process, then the first column of \code{X} must be all 1s.
In order to run the program stably, it is recommended that the value of X should not be too large. It is recommended to
preprocess all the items in X except the intercept item by means of preprocessing, so that the mean value of each column
is 0 and the standard deviation is \code{1/ colnum(X)}.}

\item{y}{Non-negative count response vector.}

\item{alpha}{Hyperparameter. The suggested value for alpha is 1 or 2.
When the collinearity of the load matrix is serious, the hyperparameters can be selected larger, such as 5.}

\item{itrNum}{The number of iteration steps. In general, 20 steps are enough.
If the condition number of \code{X} is large, it is recommended to greatly increase the
number of iteration steps.}

\item{thresh}{Convergence threshold for beta Change, if \code{max(abs(beta-beta_old))<threshold}, return.}

\item{flag}{It identifies whether to make model selection. The default is \code{TRUE}.}

\item{lamda_0}{The initial value of the regularization parameter for ridge regression.
The running result of the algorithm is not sensitive to this value.}

\item{fdiag}{It identifies whether to use diag Approximation to speed up the algorithm.}

\item{subItrNum}{Maximum number of steps for subprocess iterations.}
}
\value{
Coefficient vector.
}
\description{
Fit a Poisson model the Global Adaptive Generative Adjustment algorithm
}
\examples{
# Poisson
set.seed(2022)
p_size = 30
sample_size=300
R1 = 1/sqrt(p_size)
R2 = 5
ratio = 0.5 #The ratio of zeroes in coefficients
# Set the true coefficients
zeroNum = round(ratio*p_size)
ind = sample(1:p_size,zeroNum)
beta_true = runif(p_size,0,R2)
beta_true[ind] = 0
X = R1*matrix(rnorm(sample_size * p_size), ncol = p_size)
X[1:sample_size,1]=1
y = rpois(sample_size,lambda = as.vector(exp(X\%*\%beta_true)))
y = as.vector(y)
# Estimate
fit = GAGAs(X,y,alpha = 2,family="poisson")
Eb = fit$beta
cat("\n err:", norm(Eb-beta_true,type="2")/norm(beta_true,type="2"))
cat("\n acc:", cal.w.acc(as.character(Eb!=0),as.character(beta_true!=0)))


}
