% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrapezoidalFuzzyNumberList.R
\name{TrapezoidalFuzzyNumberList}
\alias{TrapezoidalFuzzyNumberList}
\title{'TrapezoidalFuzzyNumberList' is a child class of 'StatList'. It contains
'TrapezoidalFuzzyNumbers'.}
\description{
'TrapezoidalFuzzyNumberList' can contain valid and not valid 'TrapezoidalFuzzyNumbers'.
This class implements a version of the empty 'StatList' methods.
}
\note{
In case you find (almost surely existing) bugs or have recommendations
for improving the method, comments are welcome to the above mentioned mail addresses.
}
\examples{

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumberList$new`
## ------------------------------------------------

TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1, 2, 3, 4),
TrapezoidalFuzzyNumber$new(-8, -6, -4, -2),
TrapezoidalFuzzyNumber$new(-1, -1, 2, 3),
TrapezoidalFuzzyNumber$new(1, 2, 3, 3)))

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumberList$add`
## ------------------------------------------------

# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(0,0.1,0.2,0.3),
TrapezoidalFuzzyNumber$new(1,2,3,4),TrapezoidalFuzzyNumber$new(2,3,4,5)))$add(
FuzzyNumberList$new(c(FuzzyNumber$new(array(c(0.0, 0.5, 1.0,-1.5,-1.25,-1.0,
3.0, 2.0, 1.0), dim = c(3, 3))))),1L)

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(0,0.1,0.2,0.3),
TrapezoidalFuzzyNumber$new(1,2,3,4),TrapezoidalFuzzyNumber$new(2,3,4,5)))$add(
FuzzyNumberList$new(c(FuzzyNumber$new(array(c(0.0, 0.5, 1.0,-1.5,-1.25,-1.0,
3.0, 2.0, 1.0), dim = c(3, 3))))),2L,2,1,1)

# Example 3:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(0,0.1,0.2,0.3),
TrapezoidalFuzzyNumber$new(1,2,3,4),TrapezoidalFuzzyNumber$new(2,3,4,5)))$add(
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(5,6,7,8))),3L,1,1,1)

# Example 4:
F=Simulation$new()$simulCase1(10L)
S=F$mean()
F$add(S,1L)

# Example 5:
F=Simulation$new()$simulCase1(100L)
S=F$median1Norm()
F$add(S,2L,2,1,1)

# Example 6:
F=Simulation$new()$simulCase2(10L)
U=Simulation$new()$simulCase2(1L)
F$add(U,2L)

# Example 7:
F=Simulation$new()$simulCase2(10L)
U=F$transfTra()
F$add(U,2L)

# Example 8:
F=Simulation$new()$simulCase2(10L)
U=Simulation$new()$simulCase2(2L)
F$add(U,2L)

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumberList$checking`
## ------------------------------------------------

# Example 1:
TrapezoidalFuzzyNumberList$new(c(
TrapezoidalFuzzyNumber$new(1, 2, 3, 4),
TrapezoidalFuzzyNumber$new(-8, -6, -4, -2),
TrapezoidalFuzzyNumber$new(-1, -1, 2, 3),
TrapezoidalFuzzyNumber$new(1, 2, 3, 3)))$checking()

# Example 2:
TrapezoidalFuzzyNumberList$new(c(
TrapezoidalFuzzyNumber$new(1, 2, 3, 4),
TrapezoidalFuzzyNumber$new(-8, -6, -4, -2),
TrapezoidalFuzzyNumber$new(1, 0, 2, 3),
TrapezoidalFuzzyNumber$new(-1, 0, -0.5, 0),
TrapezoidalFuzzyNumber$new(-2, -4, -6, -8)))$checking()

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumberList$dthetaphi`
## ------------------------------------------------

# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1)))$dthetaphi(
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58))))

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1)))$dthetaphi(
TrapezoidalFuzzyNumberList$new( c(TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58))),1,1,1)

# Example 3:
F=Simulation$new()$simulCase1(6L)
S=Simulation$new()$simulCase1(8L)
F$dthetaphi(S,1,5,1)

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumberList$dwablphi`
## ------------------------------------------------

# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1)))$dwablphi(
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58))))

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1)))$dwablphi(
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58))),5,1,1)

# Example 3:
F=Simulation$new()$simulCase1(10L)
S=Simulation$new()$simulCase1(20L)
F$dwablphi(S)

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumberList$gsi`
## ------------------------------------------------

# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1)))$gsi()

# Example 2:
F=Simulation$new()$simulCase1(50L)
F$gsi()

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumberList$hyperI`
## ------------------------------------------------

# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1)))$hyperI()

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1)))$hyperI(0.5)

# Example 3:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(2,4,6,8)))$hyperI()

# Example 4:
F=Simulation$new()$simulFRSTra(100L,0.05,0.35,0.6,2,1)
F$hyperI()

# Example 5:
F=Simulation$new()$simulCase2(10L)
F$hyperI(0.5)

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumberList$mEstimator`
## ------------------------------------------------

# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1)))$mEstimator("Huber",0.321,0.5,10^(-5),
1L)

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1)))$mEstimator("Tukey",0.123,0.5,10^(-5),
2L,1,1,1)

# Example 3:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1)))$mEstimator("Cauchy",0.123,0.5,10^(-5),
3L,0.75,0.5,1)

# Example 4:
F=Simulation$new()$simulCase1(100L)
U=F$median1Norm()
estInitial=F$mdd(U,1L)
delta=0.5
epsilon=10^(-5)
F$mEstimator("Huber",estInitial,delta,epsilon,1L)

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumberList$mdd`
## ------------------------------------------------

# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(0,0.1,0.2,0.3),
TrapezoidalFuzzyNumber$new(1,2,3,4),TrapezoidalFuzzyNumber$new(2,3,4,5)))$mdd(
FuzzyNumberList$new(c(FuzzyNumber$new(array(c(0.0, 0.5, 1.0,-1.5,-1.25,-1.0,
3.0, 2.0, 1.0), dim = c(3, 3))))),1L)

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(0,0.1,0.2,0.3),
TrapezoidalFuzzyNumber$new(1,2,3,4),TrapezoidalFuzzyNumber$new(2,3,4,5)))$mdd(
FuzzyNumberList$new(c(FuzzyNumber$new(array(c(0.0, 0.5, 1.0,-1.5,-1.25,-1.0,
3.0, 2.0, 1.0), dim = c(3, 3))))),2L,2,1,1)

# Example 3:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(0,0.1,0.2,0.3),
TrapezoidalFuzzyNumber$new(1,2,3,4),TrapezoidalFuzzyNumber$new(2,3,4,5)))$mdd(
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(5,6,7,8))),3L,1,1,1)

# Example 4:
F=Simulation$new()$simulCase3(10L)
U=F$mean()
F$mdd(U,3L,1,2,1)

# Example 5:
F=Simulation$new()$simulCase2(10L)
U=F$median1Norm()
F$mdd(U,2L)

# Example 6:
F=Simulation$new()$simulCase2(10L)
U=Simulation$new()$simulCase2(1L)
F$mdd(U,2L)

# Example 7:
F=Simulation$new()$simulCase2(10L)
U=F$transfTra()
F$mdd(U,2L)

# Example 8:
F=Simulation$new()$simulCase2(10L)
U=Simulation$new()$simulCase2(2L)
F$mdd(U,2L)

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumberList$mean`
## ------------------------------------------------

# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1)))$mean()

# Example 2:
TrapezoidalFuzzyNumberList$new(
c(TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$mean()

# Example 3:
F=Simulation$new()$simulCase1(100L)
F$mean()

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumberList$median1Norm`
## ------------------------------------------------

# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$median1Norm()

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$median1Norm(200L)

# Example 3:
F=Simulation$new()$simulCase1(10L)
F$median1Norm(200L)

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumberList$medianWabl`
## ------------------------------------------------

# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$medianWabl()

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$medianWabl(3L)

# Example 3:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$medianWabl(3L,2.2,2.8)

# Example 4:
F=Simulation$new()$simulCase1(10L)
F$medianWabl(3L)

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumberList$qn`
## ------------------------------------------------

# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$qn(1L)

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$qn(2L,5,1,1)

# Example 3:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$qn(3L,1,1,1)

# Example 4:
F=Simulation$new()$simulCase1(10L)
F$qn(3L,1,1,1)

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumberList$rho1`
## ------------------------------------------------

# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1)))$rho1(TrapezoidalFuzzyNumberList$new(
c(TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58))))

# Example 2:
F=Simulation$new()$simulCase1(4L)
S=Simulation$new()$simulCase1(5L)
F$rho1(S)
S$rho1(F)

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumberList$sn`
## ------------------------------------------------

# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$sn(1L)

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$sn(2L,1,1,1)

# Example 3:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$sn(3L,5,1,0.5)

# Example 4:
F=Simulation$new()$simulCase1(10L)
F$sn(2L,5,1,0.5)

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumberList$tn`
## ------------------------------------------------

# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$tn(1L)

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$tn(2L,1,1,1)

# Example 3:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$tn(3L,5,1,0.5)

# Example 4:
F=Simulation$new()$simulCase1(10L)
F$tn(1L)

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumberList$transfTra`
## ------------------------------------------------

# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$transfTra()

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$transfTra(3L)

# Example 3:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$transfTra(10L)

# Example 4:
F=Simulation$new()$simulCase3(10L)
F$transfTra(200L)

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumberList$var`
## ------------------------------------------------

# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$var()

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$var(1,1,1)

# Example 3:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$var(1/3,1/3,1/5)

# Example 4:
F=Simulation$new()$simulCase1(10L)
F$var(1,1,1)

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumberList$wablphi`
## ------------------------------------------------

# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$wablphi()

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$wablphi(2,1)

# Example 3:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$wablphi(2.2,1.1)

# Example 4:
F=Simulation$new()$simulCase4(60L)
F$wablphi(2,1)

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumberList$addTrapezoidalFuzzyNumber`
## ------------------------------------------------

TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4))
)$addTrapezoidalFuzzyNumber(TrapezoidalFuzzyNumber$new(3,4,5,6))

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumberList$removeTrapezoidalFuzzyNumber`
## ------------------------------------------------

# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(2,3,4,4)))$removeTrapezoidalFuzzyNumber(1L)

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(2,3,4,4)))$removeTrapezoidalFuzzyNumber(2L)

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumberList$getDimension`
## ------------------------------------------------

# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(2,3,4,4)))$getDimension(1L)

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(2,3,4,4)))$getDimension(2L)
}
\references{
[1] De la Rosa de Saa, S.; Gil, M.A.; Gonzalez-Rodriguez, G.; Lopez, M.T.; Lubiano M.A.: Fuzzy
rating scale-based questionnaires and their statistical analysis, IEEE Transactions on
Fuzzy Systems 23(1), 111-126 (2015)

[2] De la Rosa de Saa, S.; Lubiano M.A.; Sinova, B.; Filzmoser, P.: Robust scale
estimators for fuzzy data, Advances in Data Analysis and Classification 11(4), 731-758 (2017)

[3] De la Rosa de Sáa, S.; Lubiano, M.A.; Sinova, B.; Filzmoser, P.; Gil, M.Á.: Location-free
robust scale estimates for fuzzy data, IEEE Transactions on Fuzzy Systems 29(6), 1682-1694 (2021)

[4] Lubiano, M.A.; Gil, M.A.: f-Inequality indices for fuzzy random variables, in Statistical
Modeling, Analysis and Management of Fuzzy Data (Bertoluzza, C., Gil, M.A., Ralescu, D.A., Eds.),
Physica-Verlag, 43-63 (2002)

[5] Lubiano, M.A.; Montenegro, M.; Sinova, B.; De la Rosa de Saa, S.; Gil, M.A.: Hypothesis
testing for means in connection with fuzzy rating scale-based data: algorithms and
applications, European Journal of Operational Research 251, 918-929 (2016)

[6] Sinova, B.; De la Rosa de Saa, S.; Gil, M.A.: A generalized L1-type metric between fuzzy
numbers for an approach to central tendency of fuzzy data, Information Sciences 242,
22-34 (2013)

[7] Sinova, B.; De la Rosa de Saa, S.; Lubiano, M.A.; Gil, M.A.: An overview on the statistical
central tendency for fuzzy datasets, International Journal of Uncertainty, Fuzziness and
Knowledge-Based Systems 23 (Suppl. 1), 105-132 (2015)

[8] Sinova, B.; Gil, M.A.; Colubi, A.; Van Aelst, S.: The median of a random fuzzy number. The
1-norm distance approach, Fuzzy Sets and Systems 200, 99-115 (2012)

[9] Sinova, B.; Gil, M.A.; Lopez, M.T.; Van Aelst, S.: A parameterized L2 metric between fuzzy
numbers and its parameter interpretation, Fuzzy Sets and Systems 245, 101-115 (2014)

[10] Sinova, B.; Gil, M.A.; Van Aelst, S.: M-estimates of location for the robust central
tendency of fuzzy data, IEEE Transactions on Fuzzy Systems 24(4), 945-956 (2016)
}
\author{
(s) Andrea Garcia Cernuda <uo270115@uniovi.es>, Asun Lubiano <lubiano@uniovi.es>,
Sara de la Rosa de Saa
}
\section{Super class}{
\code{\link[FuzzyStatTraEOO:StatList]{FuzzyStatTraEOO::StatList}} -> \code{TrapezoidalFuzzyNumberList}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{numbers}}{is a collection of trapezoidal fuzzy numbers.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TrapezoidalFuzzyNumberList-new}{\code{TrapezoidalFuzzyNumberList$new()}}
\item \href{#method-TrapezoidalFuzzyNumberList-add}{\code{TrapezoidalFuzzyNumberList$add()}}
\item \href{#method-TrapezoidalFuzzyNumberList-checking}{\code{TrapezoidalFuzzyNumberList$checking()}}
\item \href{#method-TrapezoidalFuzzyNumberList-dthetaphi}{\code{TrapezoidalFuzzyNumberList$dthetaphi()}}
\item \href{#method-TrapezoidalFuzzyNumberList-dwablphi}{\code{TrapezoidalFuzzyNumberList$dwablphi()}}
\item \href{#method-TrapezoidalFuzzyNumberList-gsi}{\code{TrapezoidalFuzzyNumberList$gsi()}}
\item \href{#method-TrapezoidalFuzzyNumberList-hyperI}{\code{TrapezoidalFuzzyNumberList$hyperI()}}
\item \href{#method-TrapezoidalFuzzyNumberList-mEstimator}{\code{TrapezoidalFuzzyNumberList$mEstimator()}}
\item \href{#method-TrapezoidalFuzzyNumberList-mdd}{\code{TrapezoidalFuzzyNumberList$mdd()}}
\item \href{#method-TrapezoidalFuzzyNumberList-mean}{\code{TrapezoidalFuzzyNumberList$mean()}}
\item \href{#method-TrapezoidalFuzzyNumberList-median1Norm}{\code{TrapezoidalFuzzyNumberList$median1Norm()}}
\item \href{#method-TrapezoidalFuzzyNumberList-medianWabl}{\code{TrapezoidalFuzzyNumberList$medianWabl()}}
\item \href{#method-TrapezoidalFuzzyNumberList-qn}{\code{TrapezoidalFuzzyNumberList$qn()}}
\item \href{#method-TrapezoidalFuzzyNumberList-rho1}{\code{TrapezoidalFuzzyNumberList$rho1()}}
\item \href{#method-TrapezoidalFuzzyNumberList-sn}{\code{TrapezoidalFuzzyNumberList$sn()}}
\item \href{#method-TrapezoidalFuzzyNumberList-tn}{\code{TrapezoidalFuzzyNumberList$tn()}}
\item \href{#method-TrapezoidalFuzzyNumberList-transfTra}{\code{TrapezoidalFuzzyNumberList$transfTra()}}
\item \href{#method-TrapezoidalFuzzyNumberList-var}{\code{TrapezoidalFuzzyNumberList$var()}}
\item \href{#method-TrapezoidalFuzzyNumberList-wablphi}{\code{TrapezoidalFuzzyNumberList$wablphi()}}
\item \href{#method-TrapezoidalFuzzyNumberList-addTrapezoidalFuzzyNumber}{\code{TrapezoidalFuzzyNumberList$addTrapezoidalFuzzyNumber()}}
\item \href{#method-TrapezoidalFuzzyNumberList-removeTrapezoidalFuzzyNumber}{\code{TrapezoidalFuzzyNumberList$removeTrapezoidalFuzzyNumber()}}
\item \href{#method-TrapezoidalFuzzyNumberList-getDimension}{\code{TrapezoidalFuzzyNumberList$getDimension()}}
\item \href{#method-TrapezoidalFuzzyNumberList-clone}{\code{TrapezoidalFuzzyNumberList$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumberList-new"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumberList-new}{}}}
\subsection{Method \code{new()}}{
This method creates a 'TrapezoidalFuzzyNumberList' object with all the attributes
set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumberList$new(numbers = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{numbers}}{is a list which contains n TrapezoidalFuzzyNumbers.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
The TrapezoidalFuzzyNumberList object created with all attributes set.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1, 2, 3, 4),
TrapezoidalFuzzyNumber$new(-8, -6, -4, -2),
TrapezoidalFuzzyNumber$new(-1, -1, 2, 3),
TrapezoidalFuzzyNumber$new(1, 2, 3, 3)))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumberList-add"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumberList-add}{}}}
\subsection{Method \code{add()}}{
This method calculates the scale measure Average Distance Deviation (ADD)
of a 'TrapezoidalFuzzyNumberList' with respect to a 'TrapezoidalFuzzyNumberList'
or with respect to a 'FuzzyNumberList' containing a unique fuzzy number.
The employed metric in the calculation can be the 1-norm distance, the mid/spr
distance or the (\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance. The method first checks
if both 'StatLists' are in the correct form (tested by the checking method).
See De la Rosa de Saa et al. (2017) [2].
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumberList$add(s = NA, type = NA, a = 1, b = 1, theta = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{is a TrapezoidalFuzzyNumberList containing a unique TrapezoidalFuzzyNumber
or it is a FuzzyNumberList containing a unique FuzzyNumber.}

\item{\code{type}}{positive integer 1, 2 or 3: if type==1, the 1-norm distance will
be considered in the calculation of the measure ADD. If type==2, the mid/spr
distance will be considered. By contrast, if type==3, the (\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev
distance will be used.}

\item{\code{a}}{real number > 0, by default a=1. It is the first parameter of a
beta distribution which corresponds to a weighting measure on [0,1] in the
mid/spr distance or in the (\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance.}

\item{\code{b}}{real number > 0, by default b=1. It is the second parameter of a
beta distribution which corresponds to a weighting measure on [0,1] in the
mid/spr distance or in the (\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance.}

\item{\code{theta}}{real number > 0, by default theta=1. It is the weight of the
spread in the mid/spr distance and the weight of the ldev and rdev in the
(\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
the scale measure ADD, which is a real number. If the body's method
inner conditions are not met, NA will be returned.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(0,0.1,0.2,0.3),
TrapezoidalFuzzyNumber$new(1,2,3,4),TrapezoidalFuzzyNumber$new(2,3,4,5)))$add(
FuzzyNumberList$new(c(FuzzyNumber$new(array(c(0.0, 0.5, 1.0,-1.5,-1.25,-1.0,
3.0, 2.0, 1.0), dim = c(3, 3))))),1L)

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(0,0.1,0.2,0.3),
TrapezoidalFuzzyNumber$new(1,2,3,4),TrapezoidalFuzzyNumber$new(2,3,4,5)))$add(
FuzzyNumberList$new(c(FuzzyNumber$new(array(c(0.0, 0.5, 1.0,-1.5,-1.25,-1.0,
3.0, 2.0, 1.0), dim = c(3, 3))))),2L,2,1,1)

# Example 3:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(0,0.1,0.2,0.3),
TrapezoidalFuzzyNumber$new(1,2,3,4),TrapezoidalFuzzyNumber$new(2,3,4,5)))$add(
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(5,6,7,8))),3L,1,1,1)

# Example 4:
F=Simulation$new()$simulCase1(10L)
S=F$mean()
F$add(S,1L)

# Example 5:
F=Simulation$new()$simulCase1(100L)
S=F$median1Norm()
F$add(S,2L,2,1,1)

# Example 6:
F=Simulation$new()$simulCase2(10L)
U=Simulation$new()$simulCase2(1L)
F$add(U,2L)

# Example 7:
F=Simulation$new()$simulCase2(10L)
U=F$transfTra()
F$add(U,2L)

# Example 8:
F=Simulation$new()$simulCase2(10L)
U=Simulation$new()$simulCase2(2L)
F$add(U,2L)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumberList-checking"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumberList-checking}{}}}
\subsection{Method \code{checking()}}{
This method checks that the numbers that contain this class are given in the
correct format, checks that all individual 'TrapezoidalFuzzyNumber' is valid
according its conditions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumberList$checking(verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbose}}{if TRUE the messages are written to the console unless the
user actively decides to set verbose=FALSE.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
TRUE if all TrapezoidalFuzzyNumbers are valid. Otherwise, FALSE.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
TrapezoidalFuzzyNumberList$new(c(
TrapezoidalFuzzyNumber$new(1, 2, 3, 4),
TrapezoidalFuzzyNumber$new(-8, -6, -4, -2),
TrapezoidalFuzzyNumber$new(-1, -1, 2, 3),
TrapezoidalFuzzyNumber$new(1, 2, 3, 3)))$checking()

# Example 2:
TrapezoidalFuzzyNumberList$new(c(
TrapezoidalFuzzyNumber$new(1, 2, 3, 4),
TrapezoidalFuzzyNumber$new(-8, -6, -4, -2),
TrapezoidalFuzzyNumber$new(1, 0, 2, 3),
TrapezoidalFuzzyNumber$new(-1, 0, -0.5, 0),
TrapezoidalFuzzyNumber$new(-2, -4, -6, -8)))$checking()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumberList-dthetaphi"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumberList-dthetaphi}{}}}
\subsection{Method \code{dthetaphi()}}{
This method calculates the mid/spr distance between the 'TrapezoidalFuzzyNumbers'
contained in the current object and the one passed as parameter, which should
be given in the desired format. For this, the method first checks if the
input 'TrapezoidalFuzzyNumberList' s is in the correct form (tested by the
checking method).
See Lubiano et al. (2016) [5].
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumberList$dthetaphi(s = NA, a = 1, b = 1, theta = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{TrapezoidalFuzzyNumberList containing TrapezoidalFuzzyNumbers characterized
by their four values inf0, inf1, sup1, sup0. The method first calls checking
to check if the TrapezoidalFuzzyNumberList has the correct format.}

\item{\code{a}}{real number > 0, by default a=1. It is the first parameter of a
beta distribution which corresponds to a weighting measure on [0,1].}

\item{\code{b}}{real number > 0, by default b=1. It is the second parameter of a
beta distribution which corresponds to a weighting measure on [0,1].}

\item{\code{theta}}{real number > 0, by default theta=1. It is the weight of the
spread in the mid/spr distance.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
a matrix containing the mid/spr distances between the two previous
mentioned TrapezoidalFuzzyNumberLists. If the body's method inner conditions
are not met, NA will be returned.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1)))$dthetaphi(
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58))))

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1)))$dthetaphi(
TrapezoidalFuzzyNumberList$new( c(TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58))),1,1,1)

# Example 3:
F=Simulation$new()$simulCase1(6L)
S=Simulation$new()$simulCase1(8L)
F$dthetaphi(S,1,5,1)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumberList-dwablphi"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumberList-dwablphi}{}}}
\subsection{Method \code{dwablphi()}}{
This method calculates the (\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance
between the 'TrapezoidalFuzzyNumbers' contained in two 'TrapezoidalFuzzyNumberLists',
which should be given in the desired format. For this, the method first
checks if the two 'TrapezoidalFuzzyNumberLists' are in the correct form (tested
by the checking method).
See Sinova et al. (2013) [6] and Sinova et al. (2016) [10].
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumberList$dwablphi(s = NA, a = 1, b = 1, theta = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{TrapezoidalFuzzyNumberList containing TrapezoidalFuzzyNumbers characterized
by their four values inf0, inf1, sup1, sup0. The method first calls checking
to check if the TrapezoidalFuzzyNumberList has the correct format..}

\item{\code{a}}{real number > 0, by default a=1. It is the first parameter of a
beta distribution which corresponds to a weighting measure on [0,1].}

\item{\code{b}}{real number > 0, by default b=1. It is the second parameter of a
beta distribution which corresponds to a weighting measure on [0,1].}

\item{\code{theta}}{real number > 0, by default theta=1. It is the weight of the
ldev and rdev in the (\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
a matrix containing the (\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distances
between the two previous mentioned TrapezoidalFuzzyNumberLists. If the body's
method inner conditions are not met, NA will be returned.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1)))$dwablphi(
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58))))

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1)))$dwablphi(
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58))),5,1,1)

# Example 3:
F=Simulation$new()$simulCase1(10L)
S=Simulation$new()$simulCase1(20L)
F$dwablphi(S)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumberList-gsi"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumberList-gsi}{}}}
\subsection{Method \code{gsi()}}{
This method calculates the Gini-Simpson diversity index for a sample of
'TrapezoidalFuzzyNumbers' contained in a 'TrapezoidalFuzzyNumberList'.
The method first checks if the 'TrapezoidalFuzzyNumberList' is given in
the correct form (tested by the checking method).
See De la Rosa de Saa et al. (2015) [1].
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumberList$gsi()}\if{html}{\out{</div>}}
}

\subsection{Details}{
See examples.
}

\subsection{Returns}{
the Gini-Simpson diversity index, which is a real number. If the body's
method inner conditions are not met, NA will be returned.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1)))$gsi()

# Example 2:
F=Simulation$new()$simulCase1(50L)
F$gsi()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumberList-hyperI"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumberList-hyperI}{}}}
\subsection{Method \code{hyperI()}}{
This method calculates the hyperbolic inequality index for a sample of
'TrapezoidalFuzzyNumbers' contained in a 'TrapezoidalFuzzyNumberList'.
The method first checks if the 'TrapezoidalFuzzyNumberList' is given in
the correct form (tested by the checking method) and if all 'TrapezoidalFuzzyNumbers'
are positive.
See De la Rosa de Saa et al. (2015) [1] and Lubiano and Gil (2002) [4].
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumberList$hyperI(c = 0, verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{c}}{number in [0,0.5]. The c*100% trimmed mean will be used in the calculation
of the hyperbolic inequality index.}

\item{\code{verbose}}{if TRUE the messages are written to the console unless the
user actively decides to set verbose=FALSE.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
the hyperbolic inequality index, which is a real number. If the body's
method inner conditions are not met, NA will be returned.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1)))$hyperI()

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1)))$hyperI(0.5)

# Example 3:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(2,4,6,8)))$hyperI()

# Example 4:
F=Simulation$new()$simulFRSTra(100L,0.05,0.35,0.6,2,1)
F$hyperI()

# Example 5:
F=Simulation$new()$simulCase2(10L)
F$hyperI(0.5)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumberList-mEstimator"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumberList-mEstimator}{}}}
\subsection{Method \code{mEstimator()}}{
This method calculates the M-estimator of scale with loss method given
in a 'TrapezoidalFuzzyNumberList' containing 'TrapezoidalFuzzyNumbers'.
For computing the M-estimator, a method called “iterative reweighting” is
used. The employed metric in the M-equation can be the 1-norm distance, the
mid/spr distance or the (\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance.
The method first checks if the 'TrapezoidalFuzzyNumberList' is given in the
correct form (tested by the checking method).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumberList$mEstimator(
  f = NA,
  estInitial = NA,
  delta = NA,
  epsilon = NA,
  type = NA,
  a = 1,
  b = 1,
  theta = 1
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{f}}{is the name of the loss function. It can be "Huber", "Tukey" or "Cauchy".}

\item{\code{estInitial}}{real number > 0.}

\item{\code{delta}}{real number in (0,1). It is present in the f-equation.}

\item{\code{epsilon}}{real number > 0. It is the tolerance allowed in the algorithm.}

\item{\code{type}}{positive integer 1, 2 or 3: if type==1, the 1-norm distance will
be considered in the calculation of the measure ADD. If type==2, the mid/spr
distance will be considered. By contrast, if type==3, the (\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev
distance will be used.}

\item{\code{a}}{real number > 0, by default a=1. It is the first parameter of a
beta distribution which corresponds to a weighting measure on [0,1] in the
mid/spr distance or in the (\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance.}

\item{\code{b}}{real number > 0, by default b=1. It is the second parameter of a
beta distribution which corresponds to a weighting measure on [0,1] in the
mid/spr distance or in the (\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance.}

\item{\code{theta}}{real number > 0, by default theta=1. It is the weight of the
spread in the mid/spr distance and the weight of the ldev and rdev in the
(\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
the value of the M-estimator of scale, which is a real number. If the
body's method inner conditions are not met, NA will be returned.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1)))$mEstimator("Huber",0.321,0.5,10^(-5),
1L)

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1)))$mEstimator("Tukey",0.123,0.5,10^(-5),
2L,1,1,1)

# Example 3:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1)))$mEstimator("Cauchy",0.123,0.5,10^(-5),
3L,0.75,0.5,1)

# Example 4:
F=Simulation$new()$simulCase1(100L)
U=F$median1Norm()
estInitial=F$mdd(U,1L)
delta=0.5
epsilon=10^(-5)
F$mEstimator("Huber",estInitial,delta,epsilon,1L)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumberList-mdd"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumberList-mdd}{}}}
\subsection{Method \code{mdd()}}{
This method calculates the scale measure Median Distance Deviation (MDD)
of a 'TrapezoidalFuzzyNumberList' with respect to a 'TrapezoidalFuzzyNumberList'
or with respect to a 'FuzzyNumberList' with a unique fuzzy number.
The employed metric in the calculation can be the 1-norm distance, the mid/spr
distance or the (\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance. The method first checks
if both 'StatLists' are in the correct form (tested by the checking method).
See De la Rosa de Saa et al. (2015) [2] and De la Rosa de Saa et al. (2021) [3].
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumberList$mdd(s = NA, type = NA, a = 1, b = 1, theta = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{is a TrapezoidalFuzzyNumberList containing a unique TrapezoidalFuzzyNumber
or it is a FuzzyNumberList containing a unique FuzzyNumber.}

\item{\code{type}}{positive integer 1, 2 or 3: if type==1, the 1-norm distance will
be considered in the calculation of the measure ADD. If type==2, the mid/spr
distance will be considered. By contrast, if type==3, the (\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev
distance will be used.}

\item{\code{a}}{real number > 0, by default a=1. It is the first parameter of a
beta distribution which corresponds to a weighting measure on [0,1] in the
mid/spr distance or in the (\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance.}

\item{\code{b}}{real number > 0, by default b=1. It is the second parameter of a
beta distribution which corresponds to a weighting measure on [0,1] in the
mid/spr distance or in the (\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance.}

\item{\code{theta}}{real number > 0, by default theta=1. It is the weight of the
spread in the mid/spr distance and the weight of the ldev and rdev in the
(\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
the scale measure MDD, which is a real number.If the body's
method inner conditions are not met, NA will be returned.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(0,0.1,0.2,0.3),
TrapezoidalFuzzyNumber$new(1,2,3,4),TrapezoidalFuzzyNumber$new(2,3,4,5)))$mdd(
FuzzyNumberList$new(c(FuzzyNumber$new(array(c(0.0, 0.5, 1.0,-1.5,-1.25,-1.0,
3.0, 2.0, 1.0), dim = c(3, 3))))),1L)

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(0,0.1,0.2,0.3),
TrapezoidalFuzzyNumber$new(1,2,3,4),TrapezoidalFuzzyNumber$new(2,3,4,5)))$mdd(
FuzzyNumberList$new(c(FuzzyNumber$new(array(c(0.0, 0.5, 1.0,-1.5,-1.25,-1.0,
3.0, 2.0, 1.0), dim = c(3, 3))))),2L,2,1,1)

# Example 3:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(0,0.1,0.2,0.3),
TrapezoidalFuzzyNumber$new(1,2,3,4),TrapezoidalFuzzyNumber$new(2,3,4,5)))$mdd(
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(5,6,7,8))),3L,1,1,1)

# Example 4:
F=Simulation$new()$simulCase3(10L)
U=F$mean()
F$mdd(U,3L,1,2,1)

# Example 5:
F=Simulation$new()$simulCase2(10L)
U=F$median1Norm()
F$mdd(U,2L)

# Example 6:
F=Simulation$new()$simulCase2(10L)
U=Simulation$new()$simulCase2(1L)
F$mdd(U,2L)

# Example 7:
F=Simulation$new()$simulCase2(10L)
U=F$transfTra()
F$mdd(U,2L)

# Example 8:
F=Simulation$new()$simulCase2(10L)
U=Simulation$new()$simulCase2(2L)
F$mdd(U,2L)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumberList-mean"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumberList-mean}{}}}
\subsection{Method \code{mean()}}{
Given a sample of 'TrapezoidalFuzzyNumbers' contained in a 'TrapezoidalFuzzyNumberList',
the method calculates the Aumann-type mean of these numbers (which is a 'TrapezoidalFuzzyNumber'
too). The method first checks if the 'TrapezoidalFuzzyNumberList' is given
in the correct form (tested by the checking method).
See Sinova et al. (2015) [7].
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumberList$mean()}\if{html}{\out{</div>}}
}

\subsection{Details}{
See examples.
}

\subsection{Returns}{
the Aumann-type mean, given as a TrapezoidalFuzzyNumber contained in
a TrapezoidalFuzzyNumberList. If the body'smethod inner conditions are not met,
NA will be returned.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1)))$mean()

# Example 2:
TrapezoidalFuzzyNumberList$new(
c(TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$mean()

# Example 3:
F=Simulation$new()$simulCase1(100L)
F$mean()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumberList-median1Norm"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumberList-median1Norm}{}}}
\subsection{Method \code{median1Norm()}}{
Given a sample of 'TrapezoidalFuzzyNumbers' contained in a 'TrapezoidalFuzzyNumberList',
the method calculates the 1-norm median of these numbers, characterized
by means of nl equidistant \eqn{\alpha}-levels (by default nl=101), including
always the 0 and 1 levels, with their infimum and supremum values. The function
first checks if the 'TrapezoidalFuzzyNumberList' is given in the correct form
(tested by the checking method).
See Sinova et al. (2012) [8].
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumberList$median1Norm(nl = 101L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nl}}{positive integer, by default nl=101. It indicates the number of desired
\eqn{\alpha}-levels for characterizing the 1-norm median.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
the 1-norm median, given in form of a FuzzyNumber contained in a
FuzzyNumberList. If the body's  method inner conditions are not met, NA will
be returned.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$median1Norm()

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$median1Norm(200L)

# Example 3:
F=Simulation$new()$simulCase1(10L)
F$median1Norm(200L)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumberList-medianWabl"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumberList-medianWabl}{}}}
\subsection{Method \code{medianWabl()}}{
Given a sample of 'TrapezoidalFuzzyNumbers' contained in a 'TrapezoidalFuzzyNumberList',
the method calculates the \eqn{\phi}-wabl/ldev/rdev median of these numbers,
characterized by means of nl equidistant \eqn{\alpha}-levels (by default nl=101),
including always the 0 and 1 levels, with their infimum and supremum values.
The method first checks if the 'TrapezoidalFuzzyNumberList' is given in the
correct form (tested by the checking method).
See Sinova et al. (2013) [6] and Sinova et al. (2016) [10].
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumberList$medianWabl(nl = 101L, a = 1, b = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nl}}{positive integer, by default nl=101. It indicates the number of desired
\eqn{\alpha}-levels for characterizing the \eqn{\phi}-wabl/ldev/rdev median.}

\item{\code{a}}{real number > 0, by default a=1. It is the first parameter of a
beta distribution which corresponds to a weighting measure on [0,1].}

\item{\code{b}}{real number > 0, by default b=1. It is the second parameter of a
beta distribution which corresponds to a weighting measure on [0,1].}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
the \eqn{\phi}-wabl/ldev/rdev median in form of a FuzzyNUmber given
in a FuzzyNumberList. If the body's method inner conditions are not met, NA
will be returned.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$medianWabl()

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$medianWabl(3L)

# Example 3:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$medianWabl(3L,2.2,2.8)

# Example 4:
F=Simulation$new()$simulCase1(10L)
F$medianWabl(3L)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumberList-qn"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumberList-qn}{}}}
\subsection{Method \code{qn()}}{
This method calculates scale measure Qn for a matrix of 'TrapezoidalFuzzyNumbers'
contained in the current 'TrapezoidalFuzzyNumber'. The  employed metric
in the calculation can be the 1-norm distance, the mid/spr distance or the
(\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance. The method first checks
if the 'TrapezoidalFuzzyNumberList' is given in the correct form (tested
by the checking method).
See De la Rosa de Saa et al. (2021) [3].
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumberList$qn(type = NA, a = 1, b = 1, theta = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{integer number that can be 1, 2 or 3: if type==1, the 1-norm
distance will be considered in the calculation of the measure ADD. If type==2,
the mid/spr distance will be considered. By contrast, if type==3, the
(\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance will be used.}

\item{\code{a}}{real number > 0, by default a=1. It is the first parameter of a
beta distribution which corresponds to a weighting measure on [0,1] in the
mid/spr distance or the (\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance.}

\item{\code{b}}{real number > 0, by default b=1. It is the second parameter of a
beta distribution which corresponds to a weighting measure on [0,1] in the
mid/spr distance or the (\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance.}

\item{\code{theta}}{real number > 0, by default theta=1. It is the weight of the
spread in the mid/spr distance and the weight of the ldev and rdev in the
(\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
the scale measure Qn, which is a real number. If the body's
method inner conditions are not met, NA will be returned.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$qn(1L)

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$qn(2L,5,1,1)

# Example 3:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$qn(3L,1,1,1)

# Example 4:
F=Simulation$new()$simulCase1(10L)
F$qn(3L,1,1,1)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumberList-rho1"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumberList-rho1}{}}}
\subsection{Method \code{rho1()}}{
This method calculates the 1-norm distance between the 'TrapezoidalFuzzyNumbers'
contained in two 'TrapezoidalFuzzyNumberLists', which should be given in the
desired format. For this, the method first checks if the two 'TrapezoidalFuzzyNumberLists'
are in the correct form (tested by the checking method).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumberList$rho1(s = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{TrapezoidalFuzzyNumberList containing TrapezoidalFuzzyNumbers
characterized by their four values inf0, inf1, sup1, sup0. The method first
calls checking to check if it has the correct format.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
a matrix containing the 1-norm distances between the two previous
mentioned TrapezoidalFuzzyNumberLists. If the body's method inner conditions
are not met, NA will be returned.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1)))$rho1(TrapezoidalFuzzyNumberList$new(
c(TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58))))

# Example 2:
F=Simulation$new()$simulCase1(4L)
S=Simulation$new()$simulCase1(5L)
F$rho1(S)
S$rho1(F)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumberList-sn"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumberList-sn}{}}}
\subsection{Method \code{sn()}}{
This method calculates scale measure Sn for a matrix of 'TrapezoidalFuzzyNumbers'
contained in the current 'TrapezoidalFuzzyNumber'. The employed metric
in the calculation can be the 1-norm distance, the mid/spr distance or the
(\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance. The method first checks
if the 'TrapezoidalFuzzyNumberList' is given in the correct form (tested
by the checking method).
See De la Rosa de Saa et al. (2021) [3].
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumberList$sn(type = NA, a = 1, b = 1, theta = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{integer number that can be 1, 2 or 3: if type==1, the 1-norm
distance will be considered in the calculation of the measure ADD. If type==2,
the mid/spr distance will be considered. By contrast, if type==3, the
(\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance will be used.}

\item{\code{a}}{real number > 0, by default a=1. It is the first parameter of a
beta distribution which corresponds to a weighting measure on [0,1] in the
mid/spr distance or the (\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance.}

\item{\code{b}}{real number > 0, by default b=1. It is the second parameter of a
beta distribution which corresponds to a weighting measure on [0,1] in the
mid/spr distance or the (\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance.}

\item{\code{theta}}{real number > 0, by default theta=1. It is the weight of the
spread in the mid/spr distance and the weight of the ldev and rdev in the
(\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
the scale measure Sn, which is a real number. If the body's
method inner conditions are not met, NA will be returned.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$sn(1L)

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$sn(2L,1,1,1)

# Example 3:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$sn(3L,5,1,0.5)

# Example 4:
F=Simulation$new()$simulCase1(10L)
F$sn(2L,5,1,0.5)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumberList-tn"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumberList-tn}{}}}
\subsection{Method \code{tn()}}{
This method calculates scale measure Tn for a matrix of 'TrapezoidalFuzzyNumbers'
contained in the current 'TrapezoidalFuzzyNumber'. The employed metric
in the calculation can be the 1-norm distance, the mid/spr distance or the
(\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance. The method first checks
if the 'TrapezoidalFuzzyNumberList' is given in the correct form (tested
by the checking method).
See De la Rosa de Saa et al. (2021) [3].
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumberList$tn(type = NA, a = 1, b = 1, theta = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{integer number that can be 1, 2 or 3: if type==1, the 1-norm
distance will be considered in the calculation of the measure ADD. If type==2,
the mid/spr distance will be considered. By contrast, if type==3, the
(\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance will be used.}

\item{\code{a}}{real number > 0, by default a=1. It is the first parameter of a
beta distribution which corresponds to a weighting measure on [0,1] in the
mid/spr distance or the (\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance.}

\item{\code{b}}{real number > 0, by default b=1. It is the second parameter of a
beta distribution which corresponds to a weighting measure on [0,1] in the
mid/spr distance or the (\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance.}

\item{\code{theta}}{real number > 0, by default theta=1. It is the weight of the
spread in the mid/spr distance and the weight of the ldev and rdev in the
(\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
the scale measure Tn, which is a real number. If the body's
method inner conditions are not met, NA will be returned.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$tn(1L)

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$tn(2L,1,1,1)

# Example 3:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$tn(3L,5,1,0.5)

# Example 4:
F=Simulation$new()$simulCase1(10L)
F$tn(1L)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumberList-transfTra"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumberList-transfTra}{}}}
\subsection{Method \code{transfTra()}}{
This method transforms a 'TrapezoidalFuzzyNumberList' containing 'TrapezoidalFuzzyNumbers'
characterized by their four values inf0, inf1, sup1, sup0 into a 'FuzzyNumberList'
containing these same amount of fuzzy numbers, characterized by means of
nl equidistant \eqn{\alpha}-levels each (by default nl=101). The method first
checks if the 'TrapezoidalFuzzyNumberList' is given in the correct form (tested
by its method checking). In case yes, the method returns a 'FuzzyNumberList'
given in the format explained in its method checking.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumberList$transfTra(nl = 101L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nl}}{positive integer, by default nl=101. It indicates the number of desired
\eqn{\alpha}-levels for characterizing the trapezoidal fuzzy numbers.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
a FuzzyNumberList containing the transformed TrapezoidalFuzzyNumbers
into FuzzyNumbers. If the body's method inner conditions are not met, NA will
be returned.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$transfTra()

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$transfTra(3L)

# Example 3:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$transfTra(10L)

# Example 4:
F=Simulation$new()$simulCase3(10L)
F$transfTra(200L)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumberList-var"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumberList-var}{}}}
\subsection{Method \code{var()}}{
Given a sample of 'TrapezoidalFuzzyNumbers' contained in a 'TrapezoidalFuzzyNumberList',
the method calculates the variance of these numbers with respect to the
mid/spr distance. The method first checks if the 'TrapezoidalFuzzyNumberList'
is given in the correct form (tested by the checking method).
See De la Rosa de Saa et al. (2017) [2].
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumberList$var(a = 1, b = 1, theta = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{a}}{real number > 0, by default a=1. It is the first parameter of a
beta distribution which corresponds to a weighting measure on [0,1].}

\item{\code{b}}{real number > 0, by default b=1. It is the second parameter of a
beta distribution which corresponds to a weighting measure on [0,1].}

\item{\code{theta}}{real number > 0, by default theta=1. It is the weight of the
spread in the mid/spr distance.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
the variance of the sample with respect to the mid/spr distance,
which is a real number. If the body's method inner conditions are not met,
NA will be returned.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$var()

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$var(1,1,1)

# Example 3:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$var(1/3,1/3,1/5)

# Example 4:
F=Simulation$new()$simulCase1(10L)
F$var(1,1,1)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumberList-wablphi"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumberList-wablphi}{}}}
\subsection{Method \code{wablphi()}}{
Given a sample of 'TrapezoidalFuzzyNumbers' contained in a 'TrapezoidalFuzzyNumberList',
the method calculates the \eqn{\phi}-wabl value for each of these numbers.
The method first checks if the 'TrapezoidalFuzzyNumberList' is given in the
correct form (tested by the checking method).
See Sinova et al. (2014) [9].
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumberList$wablphi(a = 1, b = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{a}}{real number > 0, by default a=1. It is the first parameter of a
beta distribution which corresponds to a weighting measure on [0,1].}

\item{\code{b}}{real number > 0, by default b=1. It is the second parameter of a
beta distribution which corresponds to a weighting measure on [0,1].}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
a vector giving the \eqn{\phi}-wabl values of each TrapezoidalFuzzyNumber.
If the body's method inner conditions are not met, NA will be returned.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$wablphi()

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$wablphi(2,1)

# Example 3:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(-4,-3,-2,-1),TrapezoidalFuzzyNumber$new(1.5,2,3.75,4),
TrapezoidalFuzzyNumber$new(-4.2,-3.6,-2,-1.58)))$wablphi(2.2,1.1)

# Example 4:
F=Simulation$new()$simulCase4(60L)
F$wablphi(2,1)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumberList-addTrapezoidalFuzzyNumber"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumberList-addTrapezoidalFuzzyNumber}{}}}
\subsection{Method \code{addTrapezoidalFuzzyNumber()}}{
This method adds a 'TrapezoidalFuzzyNumber' to the current collection inside
the current 'TrapezoidalFuzzyNumberList'. Therefore, the dimensions' field
is increased in a unit.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumberList$addTrapezoidalFuzzyNumber(n = NA, verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{is the TrapezoidalFuzzyNumber to be added to the current collection
inside the current TrapezoidalFuzzyNumberList.}

\item{\code{verbose}}{if TRUE the messages are written to the console unless the
user actively decides to set verbose=FALSE.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
nothing.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4))
)$addTrapezoidalFuzzyNumber(TrapezoidalFuzzyNumber$new(3,4,5,6))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumberList-removeTrapezoidalFuzzyNumber"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumberList-removeTrapezoidalFuzzyNumber}{}}}
\subsection{Method \code{removeTrapezoidalFuzzyNumber()}}{
This method removes a 'TrapezoidalFuzzyNumber' to the current collection inside
the current 'TrapezoidalFuzzyNumberList'. Therefore, the dimensions' field
is decreased in a unit.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumberList$removeTrapezoidalFuzzyNumber(i = NA, verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{is the position of the TrapezoidalFuzzyNumber to be removed in the
current collection inside the current TrapezoidalFuzzyNumberList.}

\item{\code{verbose}}{if TRUE the messages are written to the console unless the
user actively decides to set verbose=FALSE.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
nothing.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(2,3,4,4)))$removeTrapezoidalFuzzyNumber(1L)

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(2,3,4,4)))$removeTrapezoidalFuzzyNumber(2L)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumberList-getDimension"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumberList-getDimension}{}}}
\subsection{Method \code{getDimension()}}{
This method gives the number contained in the dimension passed as parameter
when the dimension is greater than 0 and not greater than the dimensions
of the TrapezoidalFuzzyNumberList's numbers array.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumberList$getDimension(i = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{is the dimension of the TrapezoidalFuzzyNumber wanted to be retrieved.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
The TrapezoidalFuzzyNumber contained in the dimension passed as parameter
or an error if the dimension is not valid.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(2,3,4,4)))$getDimension(1L)

# Example 2:
TrapezoidalFuzzyNumberList$new(c(TrapezoidalFuzzyNumber$new(1,2,3,4),
TrapezoidalFuzzyNumber$new(2,3,4,4)))$getDimension(2L)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumberList-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumberList-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumberList$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
