% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyNumberList.R
\name{FuzzyNumberList}
\alias{FuzzyNumberList}
\title{'FuzzyNumberList' is a child class of 'StatList'. It contains 'FuzzyNumbers'.}
\description{
'FuzzyNumberList' can contain valid and not valid 'FuzzyNumbers'.
This class implements a version of the empty 'StatList' methods.
}
\note{
In case you find (almost surely existing) bugs or have recommendations
for improving the method, comments are welcome to the above mentioned mail addresses.
}
\examples{

## ------------------------------------------------
## Method `FuzzyNumberList$new`
## ------------------------------------------------

# Example 1:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 0.5, 1.0,-1.5,-1.0,-1.0, 2.0, 1.5, 1.0), dim =
c(3, 3))), FuzzyNumber$new(array(c(0.0, 0.5, 1.0,-1.5,-1.25,-1.0, 3.0, 2.0,
1.0), dim = c(3, 3)))))

# Example 2:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -1.5, -1.0, 2, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 0.5, 1.0, -1.5, -1.0, -1.0, 2.0, 1.5, 1.0),
dim = c(3, 3)))))

## ------------------------------------------------
## Method `FuzzyNumberList$checking`
## ------------------------------------------------

# Example 1:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -1.5, -1.0, 2, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 0.5, 1.0, -1.5, -1.0, -1.0, 2.0, 1.5, 1.0),
dim = c(3, 3)))))$checking()

# Example 2:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(1, 2, 3, 4), dim = c(2, 1))),
FuzzyNumber$new(array(c(0, 0.1, 0.5, 1, 2, 3), dim = c(3, 2)))))$checking()

# Example 3:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 0.5, 1.0,-1.5,-1.0,-1.0, 2.0, 1.5, 1.0), dim =
c(3, 3))),FuzzyNumber$new(array(c(0.0, 0.5, 1.0,-1.5,-1.25,-1.0, 3.0, 2.0,
1.0), dim = c(3, 3)))))$checking()

## ------------------------------------------------
## Method `FuzzyNumberList$dthetaphi`
## ------------------------------------------------

# Example 1:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -1.5, -1.0, 2, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 1.0, -1.0, -1.0, 1.5, 1.0), dim = c(2, 3)))
))$dthetaphi(
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -0.5, 0, 1.5, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 1.0, 1, 1.5, 1.5, 1.5), dim = c(2, 3))))),
1,5,1)

# Example 2:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 0.5, 1.0, -1.5, -1.0, -1.0, 2.0, 1.5, 1.0), dim =
c(3, 3))),FuzzyNumber$new(array(c(0.0, 0.5, 1.0, -1.5, -1.25, -1.0, 3.0, 2.0,
1.0), dim = c(3, 3))), FuzzyNumber$new(array(c(0.0, 0.5, 1.0, 0, 1.0, 1.0, 2.5,
2.0, 1.5), dim = c(3, 3))),FuzzyNumber$new(array(c(0.0, 0.5, 1.0, 0.5 , 1, 1.5,
3, 2.0, 2), dim = c(3, 3)))))$dthetaphi(FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 0.5, 1.0,1,1.25,1.5, 2, 1.75, 1.5), dim = c(3, 3))),
FuzzyNumber$new(array(c(0.0, 0.5, 1.0,-1,-0.5,0, 1.5, 1.25, 1), dim = c(3, 3))))
), 1, 1, 1/3)

# Example 3:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -1.5, -1.0, 2, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 1.0, -1.0, -1.0, 1.5, 1.0), dim = c(2, 3)))
))$dthetaphi(
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -0.5, 0, 1.5, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 1.0, 1, 1.5, 1.5, 1.0), dim = c(2, 3))))),
2,1,1)

# Example 4:
F=Simulation$new()$simulCase1(10L)
S=Simulation$new()$simulCase1(20L)
F=F$transfTra()
S=S$transfTra()
F$dthetaphi(S,1,5,1)

# Example 5:
F=Simulation$new()$simulCase1(10L)
S=Simulation$new()$simulCase1(10L)
F$dthetaphi(S,2,1,1/3)

# Example 6:
F=Simulation$new()$simulCase1(10L)
S=Simulation$new()$simulCase1(10L)
F=F$transfTra()
S=S$transfTra(50L)
F$dthetaphi(S,2,1,1)

## ------------------------------------------------
## Method `FuzzyNumberList$dwablphi`
## ------------------------------------------------

# Example 1:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -1.5, -1.0, 2, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 1.0, -1.0, -1.0, 1.5, 1.0), dim = c(2, 3)))
))$dwablphi(
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -0.5, 0, 1.5, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 1.0, 1, 1.5, 1.5, 1.5), dim = c(2, 3))))),
1,5,1)

# Example 2:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 0.5, 1.0, -1.5, -1.0, -1.0, 2.0, 1.5, 1.0), dim =
c(3, 3))),FuzzyNumber$new(array(c(0.0, 0.5, 1.0, -1.5, -1.25, -1.0, 3.0, 2.0,
1.0), dim = c(3, 3))), FuzzyNumber$new(array(c(0.0, 0.5, 1.0, 0, 1.0, 1.0, 2.5,
2.0, 1.5), dim = c(3, 3))),FuzzyNumber$new(array(c(0.0, 0.5, 1.0, 0.5 , 1, 1.5,
3, 2.0, 2), dim = c(3, 3)))))$dwablphi(FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 0.5, 1.0,1,1.25,1.5, 2, 1.75, 1.5), dim = c(3, 3))),
FuzzyNumber$new(array(c(0.0, 0.5, 1.0,-1,-0.5,0, 1.5, 1.25, 1), dim = c(3, 3))))
), 1, 1, 1/3)

# Example 3:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -1.5, -1.0, 2, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 1.0, -1.0, -1.0, 1.5, 1.0), dim = c(2, 3)))
))$dwablphi(
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -0.5, 0, 1.5, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 1.0, 1, 1.5, 1.5, 1.0), dim = c(2, 3))))),
2,1,1)

# Example 4:
F=Simulation$new()$simulCase1(3L)
S=Simulation$new()$simulCase1(4L)
F=F$transfTra()
S=S$transfTra()
F$dwablphi(S,2,1,1)

# Example 5:
F=Simulation$new()$simulCase1(10L)
S=Simulation$new()$simulCase1(10L)
F$dwablphi(S)

# Example 6:
F=Simulation$new()$simulCase1(10L)
S=Simulation$new()$simulCase1(10L)
F=F$transfTra()
S=S$transfTra(50L)
F$dwablphi(S,2,1,1)

## ------------------------------------------------
## Method `FuzzyNumberList$rho1`
## ------------------------------------------------

# Example 1:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -1.5, -1.0, 2, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 1.0, -1.0, -1.0, 1.5, 1.0), dim = c(2, 3)))
))$rho1(
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -0.5, 0, 1.5, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 1.0, 1, 1.5, 1.5, 1.5), dim = c(2, 3))))))

# Example 2:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 0.5, 1.0, -1.5, -1.0, -1.0, 2.0, 1.5, 1.0), dim =
c(3, 3))),FuzzyNumber$new(array(c(0.0, 0.5, 1.0, -1.5, -1.25, -1.0, 3.0, 2.0,
1.0), dim = c(3, 3))), FuzzyNumber$new(array(c(0.0, 0.5, 1.0, 0, 1.0, 1.0, 2.5,
2.0, 1.5), dim = c(3, 3))),FuzzyNumber$new(array(c(0.0, 0.5, 1.0, 0.5 , 1, 1.5,
3, 2.0, 2), dim = c(3, 3)))))$rho1(FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 0.5, 1.0,1,1.25,1.5, 2, 1.75, 1.5), dim = c(3, 3))),
FuzzyNumber$new(array(c(0.0, 0.5, 1.0,-1,-0.5,0, 1.5, 1.25, 1), dim = c(3, 3))))))

# Example 3:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -1.5, -1.0, 2, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 1.0, -1.0, -1.0, 1.5, 1.0), dim = c(2, 3)))
))$rho1(
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -0.5, 0, 1.5, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 1.0, 1, 1.5, 1.5, 1.0), dim = c(2, 3))))))

# Example 4:
F=Simulation$new()$simulCase1(4L)
S=Simulation$new()$simulCase1(5L)
F=F$transfTra()
S=S$transfTra()
F$rho1(S)
S$rho1(F)

# Example 6:
F=Simulation$new()$simulCase1(4L)
S=Simulation$new()$simulCase1(5L)
F=F$transfTra()
S=S$transfTra(10L)
F$rho1(S)
S$rho1(F)

## ------------------------------------------------
## Method `FuzzyNumberList$addFuzzyNumber`
## ------------------------------------------------

# Example 1:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -1.5, -1.0, 2, 1), dim = c(2, 3)))))$addFuzzyNumber(
FuzzyNumber$new(array(c(0.0, 0.5, 1.0, -1, -0.5, 0, 1.5, 1.25, 1), dim = c(3, 3))))

# Example 2:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 0.5, 1.0, -1, -0.5, 0, 1.5, 1.25, 1), dim = c(3, 3)))
))$addFuzzyNumber( FuzzyNumber$new(array(c(0.0, 0.5, 1.0, 1, 1.25, 1.5, 2, 1.75,
1.5), dim = c(3, 3))))

## ------------------------------------------------
## Method `FuzzyNumberList$removeFuzzyNumber`
## ------------------------------------------------

# Example 1:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -1.5, -1.0, 2, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 0.5, 1.0, -1, -0.5, 0, 1.5, 1.25, 1), dim = c(3, 3)))
))$removeFuzzyNumber(1L)

# Example 2:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 0.5, 1.0, -1, -0.5, 0, 1.5, 1.25, 1), dim = c(3, 3))),
FuzzyNumber$new(array(c(0.0, 0.5, 1.0, 1, 1.25, 1.5, 2, 1.75, 1.5), dim = c(3, 3)))
))$removeFuzzyNumber(2L)

## ------------------------------------------------
## Method `FuzzyNumberList$getDimension`
## ------------------------------------------------

# Example 1:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 0.5, 1.0, -1, -0.5, 0, 1.5, 1.25, 1), dim = c(3, 3))),
FuzzyNumber$new(array(c(0.0, 0.5, 1.0, 1, 1.25, 1.5, 2, 1.75, 1.5), dim = c(3, 3)))
))$getDimension(1L)

# Example 2:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 0.5, 1.0, -1, -0.5, 0, 1.5, 1.25, 1), dim = c(3, 3))),
FuzzyNumber$new(array(c(0.0, 0.5, 1.0, 1, 1.25, 1.5, 2, 1.75, 1.5), dim = c(3, 3)))
))$getDimension(2L)
}
\references{
[1] Blanco-Fernandez, A.; Casals, R.M.; Colubi, A.; Corral, N.; Garcia-Barzana, M.; Gil, M.A.;
Gonzalez-Rodriguez, G.; Lopez, M.T.; Lubiano, M.A.; Montenegro, M.; Ramos-Guajardo, A.B.;
de la Rosa de Saa, S.; Sinova, B.: Random fuzzy sets: A mathematical tool to develop
statistical fuzzy data analysis, Iranian Journal on Fuzzy Systems 10(2), 1-28 (2013)

[2] Diamond, P.; Kloeden, P.: Metric spaces of fuzzy sets, Fuzzy Sets and Systems 35,
241-249 (1990)

[3] Sinova, B.; de la Rosa de Saa, S.; Gil, M.A.: A generalized L1-type metric between fuzzy
numbers for an approach to central tendency of fuzzy data, Information Sciences 242, 22-34
(2013)

[4] Sinova, B.; Gil, M.A.; Van Aelst, S.: M-estimates of location for the robust central
tendency of fuzzy data, IEEE Transactions on Fuzzy Systems 24(4), 945-956 (2016)
}
\author{
(s) Andrea Garcia Cernuda <uo270115@uniovi.es>, Asun Lubiano <lubiano@uniovi.es>,
Sara de la Rosa de Saa
}
\section{Super class}{
\code{\link[FuzzyStatTraEOO:StatList]{FuzzyStatTraEOO::StatList}} -> \code{FuzzyNumberList}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{numbers}}{is a collection of fuzzy numbers.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FuzzyNumberList-new}{\code{FuzzyNumberList$new()}}
\item \href{#method-FuzzyNumberList-checking}{\code{FuzzyNumberList$checking()}}
\item \href{#method-FuzzyNumberList-dthetaphi}{\code{FuzzyNumberList$dthetaphi()}}
\item \href{#method-FuzzyNumberList-dwablphi}{\code{FuzzyNumberList$dwablphi()}}
\item \href{#method-FuzzyNumberList-rho1}{\code{FuzzyNumberList$rho1()}}
\item \href{#method-FuzzyNumberList-addFuzzyNumber}{\code{FuzzyNumberList$addFuzzyNumber()}}
\item \href{#method-FuzzyNumberList-removeFuzzyNumber}{\code{FuzzyNumberList$removeFuzzyNumber()}}
\item \href{#method-FuzzyNumberList-getDimension}{\code{FuzzyNumberList$getDimension()}}
\item \href{#method-FuzzyNumberList-clone}{\code{FuzzyNumberList$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzyNumberList-new"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzyNumberList-new}{}}}
\subsection{Method \code{new()}}{
This method creates a 'FuzzyNumberList' object with the columns and dimensions
attributes set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzyNumberList$new(numbers = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{numbers}}{is a list of dimension nl x 3 x n which contains n
fuzzy numbers. nl is the number of considered \eqn{\alpha}-levels and 3 is the number of
columns of the list. The first column represents the number of considered
\eqn{\alpha}-levels, the second one represents their infimum values and the
third and last column represents their supremum values.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
The FuzzyNumberList object created with the columns and dimensions
attributes set.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 0.5, 1.0,-1.5,-1.0,-1.0, 2.0, 1.5, 1.0), dim =
c(3, 3))), FuzzyNumber$new(array(c(0.0, 0.5, 1.0,-1.5,-1.25,-1.0, 3.0, 2.0,
1.0), dim = c(3, 3)))))

# Example 2:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -1.5, -1.0, 2, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 0.5, 1.0, -1.5, -1.0, -1.0, 2.0, 1.5, 1.0),
dim = c(3, 3)))))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzyNumberList-checking"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzyNumberList-checking}{}}}
\subsection{Method \code{checking()}}{
This method checks that the numbers that contain this class are given in the correct format.
First, it checks that all individual 'FuzzyNumber' are valid according its conditions.
Second and last, it checks that all the 'FuzzyNumbers' have the same column of \eqn{\alpha}-levels.
It also set the rows attribute.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzyNumberList$checking(verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbose}}{if TRUE the messages are written to the console unless the
user actively decides to set verbose=FALSE.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
TRUE if all FuzzyNumbers are valid and have the same column of \eqn{\alpha}-levels.
Otherwise, FALSE.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -1.5, -1.0, 2, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 0.5, 1.0, -1.5, -1.0, -1.0, 2.0, 1.5, 1.0),
dim = c(3, 3)))))$checking()

# Example 2:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(1, 2, 3, 4), dim = c(2, 1))),
FuzzyNumber$new(array(c(0, 0.1, 0.5, 1, 2, 3), dim = c(3, 2)))))$checking()

# Example 3:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 0.5, 1.0,-1.5,-1.0,-1.0, 2.0, 1.5, 1.0), dim =
c(3, 3))),FuzzyNumber$new(array(c(0.0, 0.5, 1.0,-1.5,-1.25,-1.0, 3.0, 2.0,
1.0), dim = c(3, 3)))))$checking()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzyNumberList-dthetaphi"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzyNumberList-dthetaphi}{}}}
\subsection{Method \code{dthetaphi()}}{
This method calculates the mid/spr distance between the FuzzyNumbers contained
in the current object and the one passed as parameter, which should be given
in the desired format. For this, the method first checks if the input 'FuzzyNumberList'
s is in the correct form (tested by the checking method) and if the \eqn{\alpha}-levels
of all 'FuzzyNumbers' coincide.
See Blanco-Fernandez et al. (2013) [1].
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzyNumberList$dthetaphi(s = NA, a = 1, b = 1, theta = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{FuzzyNumberList containing FuzzyNumbers characterized by means of
nl \eqn{\alpha}-levels each. The method first calls checking to check if the
FuzzyNumberList s has the correct format. Moreover, the \eqn{\alpha}-levels
of the FuzzyNumberList s should coincide with the ones of the current
FuzzyNumberList (the method checks this condition).}

\item{\code{a}}{real number > 0, by default a=1. It is the first parameter of a
beta distribution which corresponds to a weighting measure on [0,1].}

\item{\code{b}}{real number > 0, by default b=1. It is the second parameter of a
beta distribution which corresponds to a weighting measure on [0,1].}

\item{\code{theta}}{real number > 0, by default theta=1. It is the weight of the
spread in the mid/spr distance.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
a matrix containing the mid/spr distances between the two previous
mentioned FuzzyNumberLists. If the body's method inner conditions are not met,
NA will be returned.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -1.5, -1.0, 2, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 1.0, -1.0, -1.0, 1.5, 1.0), dim = c(2, 3)))
))$dthetaphi(
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -0.5, 0, 1.5, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 1.0, 1, 1.5, 1.5, 1.5), dim = c(2, 3))))),
1,5,1)

# Example 2:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 0.5, 1.0, -1.5, -1.0, -1.0, 2.0, 1.5, 1.0), dim =
c(3, 3))),FuzzyNumber$new(array(c(0.0, 0.5, 1.0, -1.5, -1.25, -1.0, 3.0, 2.0,
1.0), dim = c(3, 3))), FuzzyNumber$new(array(c(0.0, 0.5, 1.0, 0, 1.0, 1.0, 2.5,
2.0, 1.5), dim = c(3, 3))),FuzzyNumber$new(array(c(0.0, 0.5, 1.0, 0.5 , 1, 1.5,
3, 2.0, 2), dim = c(3, 3)))))$dthetaphi(FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 0.5, 1.0,1,1.25,1.5, 2, 1.75, 1.5), dim = c(3, 3))),
FuzzyNumber$new(array(c(0.0, 0.5, 1.0,-1,-0.5,0, 1.5, 1.25, 1), dim = c(3, 3))))
), 1, 1, 1/3)

# Example 3:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -1.5, -1.0, 2, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 1.0, -1.0, -1.0, 1.5, 1.0), dim = c(2, 3)))
))$dthetaphi(
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -0.5, 0, 1.5, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 1.0, 1, 1.5, 1.5, 1.0), dim = c(2, 3))))),
2,1,1)

# Example 4:
F=Simulation$new()$simulCase1(10L)
S=Simulation$new()$simulCase1(20L)
F=F$transfTra()
S=S$transfTra()
F$dthetaphi(S,1,5,1)

# Example 5:
F=Simulation$new()$simulCase1(10L)
S=Simulation$new()$simulCase1(10L)
F$dthetaphi(S,2,1,1/3)

# Example 6:
F=Simulation$new()$simulCase1(10L)
S=Simulation$new()$simulCase1(10L)
F=F$transfTra()
S=S$transfTra(50L)
F$dthetaphi(S,2,1,1)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzyNumberList-dwablphi"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzyNumberList-dwablphi}{}}}
\subsection{Method \code{dwablphi()}}{
This method calculates the (\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance between
the 'FuzzyNumbers' contained in two 'FuzzyNumberLists', which should be given
in the desired format. For this, the method first checks if the two 'FuzzyNumberLists'
are in the correct form (tested by the checking method) and if the \eqn{\alpha}-levels
of all 'FuzzyNumbers' coincide.
See Sinova et al. (2013) [3] and Sinova et al. (2016) [4].
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzyNumberList$dwablphi(s = NA, a = 1, b = 1, theta = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{FuzzyNumberList containing FuzzyNumbers characterized by means of nl
\eqn{\alpha}-levels each. The method first calls checking to check if it is
in the correct format. Moreover, the \eqn{\alpha}-levels should coincide with
ones of the other FuzzyNumberList (the method checks this condition).}

\item{\code{a}}{real number > 0, by default a=1. It is the first parameter of a
beta distribution which corresponds to a weighting measure on [0,1].}

\item{\code{b}}{real number > 0, by default b=1. It is the second parameter of a
beta distribution which corresponds to a weighting measure on [0,1].}

\item{\code{theta}}{real number > 0, by default theta=1. It is the weight of the
ldev and rdev in the (\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
a matrix containing the (\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distances
between the two previous mentioned FuzzyNumberLists. If the body's
method inner conditions are not met, NA will be returned.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -1.5, -1.0, 2, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 1.0, -1.0, -1.0, 1.5, 1.0), dim = c(2, 3)))
))$dwablphi(
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -0.5, 0, 1.5, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 1.0, 1, 1.5, 1.5, 1.5), dim = c(2, 3))))),
1,5,1)

# Example 2:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 0.5, 1.0, -1.5, -1.0, -1.0, 2.0, 1.5, 1.0), dim =
c(3, 3))),FuzzyNumber$new(array(c(0.0, 0.5, 1.0, -1.5, -1.25, -1.0, 3.0, 2.0,
1.0), dim = c(3, 3))), FuzzyNumber$new(array(c(0.0, 0.5, 1.0, 0, 1.0, 1.0, 2.5,
2.0, 1.5), dim = c(3, 3))),FuzzyNumber$new(array(c(0.0, 0.5, 1.0, 0.5 , 1, 1.5,
3, 2.0, 2), dim = c(3, 3)))))$dwablphi(FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 0.5, 1.0,1,1.25,1.5, 2, 1.75, 1.5), dim = c(3, 3))),
FuzzyNumber$new(array(c(0.0, 0.5, 1.0,-1,-0.5,0, 1.5, 1.25, 1), dim = c(3, 3))))
), 1, 1, 1/3)

# Example 3:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -1.5, -1.0, 2, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 1.0, -1.0, -1.0, 1.5, 1.0), dim = c(2, 3)))
))$dwablphi(
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -0.5, 0, 1.5, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 1.0, 1, 1.5, 1.5, 1.0), dim = c(2, 3))))),
2,1,1)

# Example 4:
F=Simulation$new()$simulCase1(3L)
S=Simulation$new()$simulCase1(4L)
F=F$transfTra()
S=S$transfTra()
F$dwablphi(S,2,1,1)

# Example 5:
F=Simulation$new()$simulCase1(10L)
S=Simulation$new()$simulCase1(10L)
F$dwablphi(S)

# Example 6:
F=Simulation$new()$simulCase1(10L)
S=Simulation$new()$simulCase1(10L)
F=F$transfTra()
S=S$transfTra(50L)
F$dwablphi(S,2,1,1)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzyNumberList-rho1"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzyNumberList-rho1}{}}}
\subsection{Method \code{rho1()}}{
This method calculates the 1-norm distance between the 'FuzzyNumbers' contained
in two 'FuzzyNumberLists', which should be given in the desired format. For
this, the method first checks if the two 'FuzzyNumberLists' are in the correct
form (tested by the checking method) and if the \eqn{\alpha}-levels of all
'FuzzyNumbers' coincide.
See Diamond and Kloeden. (1990) [2].
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzyNumberList$rho1(s = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{FuzzyNumberList containing FuzzyNumbers characterized by means of nl
\eqn{\alpha}-levels each. The method first calls checking to check if it is
in the correct format. Moreover, the \eqn{\alpha}-levels should coincide with
ones of the other FuzzyNumberList (the method checks this condition).}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
a matrix containing the 1-norm distances between the two previous
mentioned FuzzyNumberLists. If the body's method inner conditions are not met,
NA will be returned.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -1.5, -1.0, 2, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 1.0, -1.0, -1.0, 1.5, 1.0), dim = c(2, 3)))
))$rho1(
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -0.5, 0, 1.5, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 1.0, 1, 1.5, 1.5, 1.5), dim = c(2, 3))))))

# Example 2:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 0.5, 1.0, -1.5, -1.0, -1.0, 2.0, 1.5, 1.0), dim =
c(3, 3))),FuzzyNumber$new(array(c(0.0, 0.5, 1.0, -1.5, -1.25, -1.0, 3.0, 2.0,
1.0), dim = c(3, 3))), FuzzyNumber$new(array(c(0.0, 0.5, 1.0, 0, 1.0, 1.0, 2.5,
2.0, 1.5), dim = c(3, 3))),FuzzyNumber$new(array(c(0.0, 0.5, 1.0, 0.5 , 1, 1.5,
3, 2.0, 2), dim = c(3, 3)))))$rho1(FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 0.5, 1.0,1,1.25,1.5, 2, 1.75, 1.5), dim = c(3, 3))),
FuzzyNumber$new(array(c(0.0, 0.5, 1.0,-1,-0.5,0, 1.5, 1.25, 1), dim = c(3, 3))))))

# Example 3:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -1.5, -1.0, 2, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 1.0, -1.0, -1.0, 1.5, 1.0), dim = c(2, 3)))
))$rho1(
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -0.5, 0, 1.5, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 1.0, 1, 1.5, 1.5, 1.0), dim = c(2, 3))))))

# Example 4:
F=Simulation$new()$simulCase1(4L)
S=Simulation$new()$simulCase1(5L)
F=F$transfTra()
S=S$transfTra()
F$rho1(S)
S$rho1(F)

# Example 6:
F=Simulation$new()$simulCase1(4L)
S=Simulation$new()$simulCase1(5L)
F=F$transfTra()
S=S$transfTra(10L)
F$rho1(S)
S$rho1(F)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzyNumberList-addFuzzyNumber"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzyNumberList-addFuzzyNumber}{}}}
\subsection{Method \code{addFuzzyNumber()}}{
This method adds a 'FuzzyNumber' to the current collection of fuzzy numbers.
Therefore, the dimensions' field is increased in a unit.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzyNumberList$addFuzzyNumber(n = NA, verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{is the FuzzyNumber to be added to the current collection of fuzzy
numbers.}

\item{\code{verbose}}{if TRUE the messages are written to the console unless the
user actively decides to set verbose=FALSE.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
NULL.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -1.5, -1.0, 2, 1), dim = c(2, 3)))))$addFuzzyNumber(
FuzzyNumber$new(array(c(0.0, 0.5, 1.0, -1, -0.5, 0, 1.5, 1.25, 1), dim = c(3, 3))))

# Example 2:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 0.5, 1.0, -1, -0.5, 0, 1.5, 1.25, 1), dim = c(3, 3)))
))$addFuzzyNumber( FuzzyNumber$new(array(c(0.0, 0.5, 1.0, 1, 1.25, 1.5, 2, 1.75,
1.5), dim = c(3, 3))))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzyNumberList-removeFuzzyNumber"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzyNumberList-removeFuzzyNumber}{}}}
\subsection{Method \code{removeFuzzyNumber()}}{
This method removes a 'FuzzyNumber' to the current collection of fuzzy numbers.
Therefore, the dimensions' field is decreased in a unit.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzyNumberList$removeFuzzyNumber(i = NA, verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{is the position of the FuzzyNumber to be removed in the current
collection of fuzzy numbers.}

\item{\code{verbose}}{if TRUE the messages are written to the console unless the
user actively decides to set verbose=FALSE.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
NULL.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 1.0, -1.5, -1.0, 2, 1), dim = c(2, 3))),
FuzzyNumber$new(array(c(0.0, 0.5, 1.0, -1, -0.5, 0, 1.5, 1.25, 1), dim = c(3, 3)))
))$removeFuzzyNumber(1L)

# Example 2:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 0.5, 1.0, -1, -0.5, 0, 1.5, 1.25, 1), dim = c(3, 3))),
FuzzyNumber$new(array(c(0.0, 0.5, 1.0, 1, 1.25, 1.5, 2, 1.75, 1.5), dim = c(3, 3)))
))$removeFuzzyNumber(2L)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzyNumberList-getDimension"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzyNumberList-getDimension}{}}}
\subsection{Method \code{getDimension()}}{
This method gives the number contained in the dimension passed as parameter
when the dimension is greater than 0 and not greater than the dimensions
of the 'FuzzyNumberList's' numbers array.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzyNumberList$getDimension(i = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{is the dimension of the FuzzyNumber wanted to be retrieved.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
The FuzzyNumber contained in the dimension passed as parameter or
an error if the dimension is not valid.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 0.5, 1.0, -1, -0.5, 0, 1.5, 1.25, 1), dim = c(3, 3))),
FuzzyNumber$new(array(c(0.0, 0.5, 1.0, 1, 1.25, 1.5, 2, 1.75, 1.5), dim = c(3, 3)))
))$getDimension(1L)

# Example 2:
FuzzyNumberList$new(c(
FuzzyNumber$new(array(c(0.0, 0.5, 1.0, -1, -0.5, 0, 1.5, 1.25, 1), dim = c(3, 3))),
FuzzyNumber$new(array(c(0.0, 0.5, 1.0, 1, 1.25, 1.5, 2, 1.75, 1.5), dim = c(3, 3)))
))$getDimension(2L)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzyNumberList-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzyNumberList-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzyNumberList$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
