% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-width.R
\docType{methods}
\name{width}
\alias{width}
\alias{width,FuzzyNumber-method}
\title{Calculate the Width of a Fuzzy Number}
\usage{
\S4method{width}{FuzzyNumber}(object, ...)
}
\arguments{
\item{object}{a fuzzy number}

\item{...}{additional arguments passed to \code{\link{expectedInterval}}}
}
\value{
Returns a single numeric value.
}
\description{
The width (Chanas, 2001) is a measure of nonspecificity of a fuzzy number.
}
\details{
The width of \eqn{A} is defined as
\eqn{width(A) := EI_U(A) - EI_L(A)},
where \eqn{EI} is the \code{\link{expectedInterval}}.
}
\references{
Chanas S. (2001), On the interval approximation of a fuzzy number,
Fuzzy Sets and Systems 122, pp. 353-356.
}
\seealso{
Other FuzzyNumber-method: \code{\link{Arithmetic}},
  \code{\link{FuzzyNumber-class}},
  \code{\link{FuzzyNumber}}, \code{\link{alphaInterval}},
  \code{\link{alphacut}}, \code{\link{ambiguity}},
  \code{\link{as.FuzzyNumber}},
  \code{\link{as.PiecewiseLinearFuzzyNumber}},
  \code{\link{as.PowerFuzzyNumber}},
  \code{\link{as.TrapezoidalFuzzyNumber}},
  \code{\link{as.character}}, \code{\link{core}},
  \code{\link{distance}}, \code{\link{evaluate}},
  \code{\link{expectedInterval}},
  \code{\link{expectedValue}},
  \code{\link{integrateAlpha}},
  \code{\link{piecewiseLinearApproximation}},
  \code{\link{plot}}, \code{\link{show}},
  \code{\link{supp}},
  \code{\link{trapezoidalApproximation}},
  \code{\link{value}}, \code{\link{weightedExpectedValue}}

Other characteristics: \code{\link{ambiguity}},
  \code{\link{expectedValue}}, \code{\link{value}},
  \code{\link{weightedExpectedValue}}
}

