% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-piecewiseLinearApproximation.R
\docType{methods}
\name{piecewiseLinearApproximation}
\alias{piecewiseLinearApproximation}
\alias{piecewiseLinearApproximation,FuzzyNumber-method}
\title{Piecewise Linear Approximation of a Fuzzy Number}
\usage{
\S4method{piecewiseLinearApproximation}{FuzzyNumber}(object,
   method=c("NearestEuclidean", "SupportCorePreserving", 
   "Naive"),
   knot.n=1, knot.alpha=seq(0, 1, length.out=knot.n+2)[-c(1,knot.n+2)],
   ..., verbose=FALSE)
}
\arguments{
\item{object}{a fuzzy number}

\item{...}{further arguments passed to \code{\link{integrateAlpha}}
[only \code{"NearestEuclidean"} and \code{"SupportCorePreserving"}]}

\item{method}{character; one of: \code{"NearestEuclidean"} (default), 
\code{"SupportCorePreserving"}, or \code{"Naive"}}

\item{knot.n}{desired number of knots (if missing, then calculated from given
\code{knot.alpha})}

\item{knot.alpha}{alpha-cuts at which knots will be positioned
(defaults to equally distributed knots)}

\item{verbose}{logical; should some technical details on the computations being performed be printed?
[only \code{"NearestEuclidean"}]}
}
\value{
Returns a \code{\link{PiecewiseLinearFuzzyNumber}} object.
}
\description{
This method finds a piecewise linear approximation \eqn{P(A)}
of a given fuzzy number \eqn{A} by using the algorithm specified by the
\code{method} parameter.
}
\details{
`\code{method}` may be one of:
\enumerate{
\item \code{NearestEuclidean}: see (Coroianu, Gagolewski, Grzegorzewski, 2013 and 2014a);
uses numerical integration, see \code{\link{integrateAlpha}}.
Slow for large \code{knot.n}.

\item \code{SupportCorePreserving}:
This method was proposed in (Coroianu et al., 2014b)
and is currently only available for \code{knot.n==1}.
It is the L2-nearest piecewise linear approximation with constraints
core(A)==core(P(A)) and supp(A)==supp(P(A));
uses numerical integration.

\item \code{Naive}:
We have core(A)==core(P(A)) and supp(A)==supp(P(A)) and the knots are
taken directly from the specified alpha cuts (linear interpolation).
}
}
\examples{
(A <- FuzzyNumber(-1, 0, 1, 3,
   lower=function(x) sqrt(x),upper=function(x) 1-sqrt(x)))
(PA <- piecewiseLinearApproximation(A, "NearestEuclidean",
   knot.n=1, knot.alpha=0.2))
}
\references{
Coroianu L., Gagolewski M., Grzegorzewski P. (2013),
Nearest Piecewise Linear Approximation of Fuzzy Numbers,
Fuzzy Sets and Systems 233, pp. 26-51.

Coroianu L., Gagolewski M., Grzegorzewski P.,
Adabitabar Firozja M., Houlari T. (2014a),
Piecewise linear approximation of fuzzy numbers preserving 
the support and core, In: Laurent A. et al. (Eds.), 
Information Processing and Management of Uncertainty in 
Knowledge-Based Systems, Part II (CCIS 443), Springer, pp. 244-254.

Coroianu L., Gagolewski M., Grzegorzewski P. (2014b),
Nearest Piecewise Linear Approximation of Fuzzy Numbers - General Case,
 submitted for publication.
}
\seealso{
Other FuzzyNumber-method: \code{\link{Arithmetic}},
  \code{\link{FuzzyNumber-class}},
  \code{\link{FuzzyNumber}}, \code{\link{alphaInterval}},
  \code{\link{alphacut}}, \code{\link{ambiguity}},
  \code{\link{as.FuzzyNumber}},
  \code{\link{as.PiecewiseLinearFuzzyNumber}},
  \code{\link{as.PowerFuzzyNumber}},
  \code{\link{as.TrapezoidalFuzzyNumber}},
  \code{\link{as.character}}, \code{\link{core}},
  \code{\link{distance}}, \code{\link{evaluate}},
  \code{\link{expectedInterval}},
  \code{\link{expectedValue}},
  \code{\link{integrateAlpha}}, \code{\link{plot}},
  \code{\link{show}}, \code{\link{supp}},
  \code{\link{trapezoidalApproximation}},
  \code{\link{value}}, \code{\link{weightedExpectedValue}},
  \code{\link{width}}

Other approximation: \code{\link{trapezoidalApproximation}}
}

