% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-as.PiecewiseLinearFuzzyNumber.R
\docType{methods}
\name{as.PiecewiseLinearFuzzyNumber}
\alias{as.PiecewiseLinearFuzzyNumber}
\alias{as.PiecewiseLinearFuzzyNumber,FuzzyNumber-method}
\alias{as.PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}
\alias{as.PiecewiseLinearFuzzyNumber,TrapezoidalFuzzyNumber-method}
\alias{as.PiecewiseLinearFuzzyNumber,numeric-method}
\title{Converts an Object to a Piecewise Linear Fuzzy Number}
\usage{
\S4method{as.PiecewiseLinearFuzzyNumber}{TrapezoidalFuzzyNumber}(object, knot.n=0,
   knot.alpha=seq(0, 1, length.out=knot.n+2)[-c(1,knot.n+2)])

\S4method{as.PiecewiseLinearFuzzyNumber}{numeric}(object, knot.n=0,
   knot.alpha=seq(0, 1, length.out=knot.n+2)[-c(1,knot.n+2)])

\S4method{as.PiecewiseLinearFuzzyNumber}{FuzzyNumber}(object, knot.n=0,
   knot.alpha=seq(0, 1, length.out=knot.n+2)[-c(1,knot.n+2)])

\S4method{as.PiecewiseLinearFuzzyNumber}{PiecewiseLinearFuzzyNumber}(object, knot.n=0,
   knot.alpha=seq(0, 1, length.out=knot.n+2)[-c(1,knot.n+2)])
}
\arguments{
\item{object}{a fuzzy number or a single numeric value (crisp number)
or vector of length two (interval)}

\item{knot.n}{the number of knots}

\item{knot.alpha}{\code{knot.n} alpha-cut values at knots,
defaults to uniformly distributed knots}
}
\value{
Returns an bject of class \code{\linkS4class{PiecewiseLinearFuzzyNumber}}.
}
\description{
This method is only for exact conversion.
For other cases (e.g. general FNs), use
\code{\link{piecewiseLinearApproximation}}.
}
\seealso{
Other FuzzyNumber-method: \code{\link{Arithmetic}},
  \code{\link{FuzzyNumber-class}},
  \code{\link{FuzzyNumber}}, \code{\link{alphaInterval}},
  \code{\link{alphacut}}, \code{\link{ambiguity}},
  \code{\link{as.FuzzyNumber}},
  \code{\link{as.PowerFuzzyNumber}},
  \code{\link{as.TrapezoidalFuzzyNumber}},
  \code{\link{as.character}}, \code{\link{core}},
  \code{\link{distance}}, \code{\link{evaluate}},
  \code{\link{expectedInterval}},
  \code{\link{expectedValue}},
  \code{\link{integrateAlpha}},
  \code{\link{piecewiseLinearApproximation}},
  \code{\link{plot}}, \code{\link{show}},
  \code{\link{supp}},
  \code{\link{trapezoidalApproximation}},
  \code{\link{value}}, \code{\link{weightedExpectedValue}},
  \code{\link{width}}

Other PiecewiseLinearFuzzyNumber-method: \code{\link{Arithmetic}},
  \code{\link{PiecewiseLinearFuzzyNumber-class}},
  \code{\link{PiecewiseLinearFuzzyNumber}},
  \code{\link{^,PiecewiseLinearFuzzyNumber,numeric-method}},
  \code{\link{alphaInterval}}, \code{\link{arctan2}},
  \code{\link{as.PowerFuzzyNumber}},
  \code{\link{as.TrapezoidalFuzzyNumber}},
  \code{\link{as.character}},
  \code{\link{expectedInterval}}, \code{\link{fapply}},
  \code{\link{maximum}}, \code{\link{minimum}},
  \code{\link{necessityExceedance}},
  \code{\link{necessityStrictExceedance}},
  \code{\link{necessityStrictUndervaluation}},
  \code{\link{necessityUndervaluation}},
  \code{\link{plot}}, \code{\link{possibilityExceedance}},
  \code{\link{possibilityStrictExceedance}},
  \code{\link{possibilityStrictUndervaluation}},
  \code{\link{possibilityUndervaluation}}

Other TrapezoidalFuzzyNumber-method: \code{\link{Arithmetic}},
  \code{\link{TrapezoidalFuzzyNumber-class}},
  \code{\link{TrapezoidalFuzzyNumber}},
  \code{\link{TriangularFuzzyNumber}},
  \code{\link{alphaInterval}},
  \code{\link{as.PowerFuzzyNumber}},
  \code{\link{as.TrapezoidalFuzzyNumber}},
  \code{\link{expectedInterval}}, \code{\link{plot}}

Other conversion: \code{\link{as.FuzzyNumber}},
  \code{\link{as.PowerFuzzyNumber}},
  \code{\link{as.TrapezoidalFuzzyNumber}},
  \code{\link{as.character}}
}

