#' Plot a Fourier descriptor object as generated by
#' \code{\link{random.fourier.descriptor}}
#' 
#' Requires ggplot2
#' 
#' @include random-fourier.descriptor.R
#' @import ggplot2
#' @param x A Fourier descriptor object generated by
#'   \code{\link{random.fourier.descriptor}}
#' @param steps At how many points along the curve should the descriptor
#'   be evaluated? This amounts to a resolution parameter. Defaults to 720.
#' @export
#' @examples
#' fourier.descriptor <- random.fourier.descriptor(12)
#'
#' plot(fourier.descriptor)
#'
#' plot(fourier.descriptor, steps = 20)
#' @usage
#' fourier.descriptor <- random.fourier.descriptor(12)
#' 
#' plot(fourier.descriptor)
#'

plot.fourier.descriptor <- function(x, steps = 720, ...)
{
  library('ggplot2')
  
  points <- cumbend.to.points(x, steps)
  
  p <- ggplot(points, aes(x = X, y = Y)) +
    geom_point() +
    theme_bw() +
    opts(panel.grid.major = theme_blank()) +
    opts(panel.grid.minor = theme_blank()) +
    opts(panel.background = theme_blank()) +
    opts(axis.title.x = theme_blank()) +
    opts(axis.title.y = theme_blank()) +
    opts(axis.ticks = theme_blank()) +
    opts(panel.border = theme_blank()) +
    opts(axis.text.x = theme_blank()) +
    opts(axis.text.y = theme_blank())
  
  print(p)
}
