% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shannon_index.R
\name{shannon_index}
\alias{shannon_index}
\title{Shannon Diversity Index for Tree Species}
\usage{
shannon_index(species_id, weights = 1, n_rep = 1)
}
\arguments{
\item{species_id}{A vector of species codes, each vector element representing
a tree. Preferably, \code{species_id} is defined in one of the species
codings supported by this package, but technically, this is not even
a requirement.}

\item{weights}{A vector of weights for each tree, default = 1, i.e. all trees
are equally weighted. Must be of length 1 or the same length as
\code{species_id}. Useful if e.g. trees should be weighted by their basal
area.}

\item{n_rep}{A vector of representation numbers for each tree, typically the
number of trees represented per ha by each tree. Does only make a
difference if it differs among the trees. Default = 1, i.e. all trees have
the same representation number.}
}
\value{
The Shannon Index value resulting from the input data
}
\description{
Species diversity index after
\insertCite{shannon_1948;textual}{ForestElementsR}. Note that this function
calculates comparable output only when the same species coding is used for
the input parameter \code{species_id}.
}
\examples{
  # Monospecific stand
  trees <- norway_spruce_1_fe_stand$trees
  shannon_index(trees$species_id)

  # Two-species mixed stand
  trees <- spruce_beech_1_fe_stand$trees
  shannon_index(trees$species_id)

  # Selection forest
  trees <- selection_forest_1_fe_stand$trees
  shannon_index(trees$species_id)

  # weigh with basal area (i.e. dbh^2)
  shannon_index(trees$species_id, weights = trees$dbh_cm^2)

  # weigh with inverse basal area (i.e. 1 / dbh^2)
  shannon_index(trees$species_id, weights = 1 / trees$dbh_cm^2)

}
\references{
\insertAllCited{}
}
\seealso{
Other structure and diversity: 
\code{\link{assmann_layers}()},
\code{\link{species_profile}()}
}
\concept{structure and diversity}
