% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stand_level_increment.R
\name{stand_level_increment}
\alias{stand_level_increment}
\title{stand_level_increment}
\usage{
stand_level_increment(time, x_remain, x_remove)
}
\arguments{
\item{time}{Vector of points in time. Must be unique and in ascending order}

\item{x_remain}{Vector of the variable of interest (typically wood volume)
for the remaining stand. "Remaining stand" means the amount which is
actually there at the corresponding point in time. The vector
\code{x_remaing} must be arranged corresponding to the input vector
\code{time}.}

\item{x_remove}{Vector of the variable of interest (typically wood volume)
for the removal stand. Each entry in this vector represents the amount
removed up to and including the corresponding point of time, but after the
previous point in time.}
}
\value{
A vector of the annual increments for the stand level variable of
interest corresponding to the input vector \code{time}. The increments
always relate to the period from (and including) the corresponding point
in time back to (and excluding) the previous point in time. Thus, the first
element of the output vector is always NA. If the input vectors are of
length 1 only, the function consequently returns NA.
}
\description{
Calculate periodic annual stand level increments from time-ordered vectors of
appropriate stand sum variables. Typically the variable of interest is a
stand's wood volume per unit area, but it works equally for stand basal area
and biomass.
}
\details{
The input vector \code{x_remove} is to be understood as the amount removed up
to (or at) the corresponding points in time and after the preceding points in
time in the \code{time} input vector. The resulting increments are to be
understood in a similar way: The entries in the increment vector relate to
the period between the entry at the same position in the \code{time} input
vector and the time entry at the position before. Therefore, the first
element of the resulting increment vector is always \code{NA}.
}
\examples{
 # Stand age, remaining and removal volume (m³/ha)
 age        <- seq(20, 70, 5)
 vol_remain <- c(65, 118, 175, 233, 293, 355, 416, 476, 534, 589, 642)
 vol_remove <- c(16,  29,  35,  39,  39,  39,  38,  37,  36,  35,  34)

 stand_level_increment(age, vol_remain, vol_remove) # m³/ha/yr

 # Works also with basal area (m²/ha)
 age        <- seq(20, 60, 5)
 ba_remain  <- c(26.0, 30.1, 32.5, 34.2, 35.5, 37.1, 38.7, 40.3, 41.9)
 ba_remove  <- c( 0.0,  5.0,  5.9,  5.4,  5.1,  4.2,  3.3,  3.0,  2.7)

 stand_level_increment(age, ba_remain, ba_remove) # m²/ha/yr

}
