% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_species_master_table.R
\docType{data}
\name{species_master_table}
\alias{species_master_table}
\title{List of Supported Species in the Package \strong{ForestElementsR}}
\format{
A tibble with the following columns are:
\describe{
\item{deciduous_conifer}{\code{Character} column with allowed values
\code{conif}, and \code{decid}} for confifer and deciduous species,
respectively
\item{genus}{\code{Character}, the genus of the species in plaintext, but
always lowercase}
\item{species_no}{\code{Character}, a three digit number, always with
leading zeroes, indicating the species inside the genus. A number was
chosen instead of plaintext, because spelling and naming must be
considered somewhat instable on that level. The order of the numbers
reflects (very) roughly the importance of the species inside a given
genus in Central Europe.}
\item{name_sci}{Scientific species names (\code{character})}
\item{name_eng}{Colloquial English species names (\code{character})}
\item{name_ger}{Colloquial German species names (\code{character})}
}
}
\usage{
species_master_table
}
\description{
A \code{data.frame} (\code{tibble}) where each row represents a
single species which is - in principle - currently supported by the package
\strong{ForestElementsR}. Each species which is coded (as a single species or a
group of species) in any of the supported \code{\link{species_codings}},
must also be represented in this data frame. No specific species coding,
however, must necessarily use all of the species listed here.

The internal universal species coding used in this package is defined in
the two columns \code{genus} and \code{species_no} (see below).
}
\keyword{datasets}
