% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se_tests.R
\name{se_tests}
\alias{se_tests}
\title{Convenient Information About the Precision of a Random Sample}
\usage{
se_tests(
  x,
  mu = 0,
  ref = c("mean", "sum"),
  alternative = c("two.sided", "greater", "less"),
  conf.level = 0.95
)
}
\arguments{
\item{x}{vector representing the sample to be evaluated}

\item{mu}{the hypothesized mean for the null hypothesis, standard = 0}

\item{ref}{the reference value for the satistic, whether it is calculated
from the mean or the sum, default = 'mean'}

\item{alternative}{a character string specifying the alternative hypothesis
for the t-statistics: "two-sided", "greater" or "less". Default is
"two-sided"}

\item{conf.level}{confidence level of the interval, Default = 0.95}
}
\value{
A list containing various statistics such as standard error,
t-statistic, degrees of freedom, p-value, and confidence interval and
margin of error as a percentage of the mean or sum, respectively.
}
\description{
Given an arbitrary random sample, t-statistics are calculated in order to
obtain information about the precision of the sample mean or sum. A list of
useful statistics is returned, most importantly the standard error and the
confidence boundaries according to the confidence level provided by the user.
}
\examples{
set.seed(123)
data <- rnorm(100, mean = 5, sd = 2)

# Test for sum
se_tests(
  data, mu = 0, ref = "sum", alternative = "two.sided", conf.level = 0.95
)
# Test for mean
se_tests(
  data, mu = 0, ref = "mean", alternative = "two.sided", conf.level = 0.95
)

}
