% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_rep_ha.R
\name{n_rep_ha}
\alias{n_rep_ha}
\title{Calculate or Return the Representation Number per ha for the Trees Contained
in a Compatible Object}
\usage{
n_rep_ha(x)
}
\arguments{
\item{x}{An object provided by \strong{ForestElementsR} containing trees for which
a representation number per ha can be meaningfully given. Such an object
must contain a data frame called 'trees'. Typically, this is an
\code{\link{fe_stand}} or \code{\link{fe_stand_spatial}} object.}
}
\value{
A vector of representation numbers corresponding to the order of the
trees data frame in \code{x}.
}
\description{
The idea behind creating this function was to allow for using the very same
evaluation algorithms for ha-based values for a broad range of different
objects, e.g. stands/research plots, inventory plots, etc.
}
\details{
If the object \code{x} contains information about its area, the
representation numbers for each tree will be calculated in the following way:

While \code{n_rep_ha} will return a vector of equal numbers for
\code{\link{fe_stand}} objects, this is less trivial for the class
\code{\link{fe_stand_spatial}}. The latter might contain 'buffer zone trees'
beyond the actual stand outline. Such trees will obtain a zero representation
number in contrast to the trees inside the outline.
If \code{x} does not contain sufficient information about its area, the
function will simply hand back the \code{n_rep_ha} column of the
\code{x$trees} data frame.
}
\examples{
# example for an fe_stand object
spruce_beech_1_fe_stand |> n_rep_ha()

# example for an fe_stand_spatial object
mm_forest_1_fe_stand_spatial |> n_rep_ha()

}
