% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_species_master.R
\name{fe_species_master}
\alias{fe_species_master}
\title{Construct a \emph{fe_species_master} Species Code Vector}
\usage{
fe_species_master(x = character())
}
\arguments{
\item{x}{Input vector to become a vector of tree species codes by the
definition \emph{master}. Any type of vector (typically \code{integer})
which, after conversion with \code{\link{as.character}}, adheres to that
definition is acceptable. If \code{x} is provided as a character vector,
leading and trailing white spaces will be trimmed.}
}
\value{
If the user input allows to construct a well-defined
\code{fe_species_master} object, this object will be returned. If not,
the function will terminate with an error.
}
\description{
User interface for constructing a vector of species codes follwing the
\emph{fe_species_master} convention
}
\details{
The \emph{master} species coding is the original species coding used by the
package \strong{ForestElementsR}. It contains each species from the
\code{\link{species_master_table}} and no species groups. See the example
section for how to look up the coding.
}
\examples{
# Libraries required for the following two examples
library(dplyr)
library(purrr)

# Look up the master species codes for all supported species
# the column species_id contains the master codes
fe_species_get_coding_table("master") |>
  print(n = Inf)

# Display a summary table which shows the number of single species behind
# each master species code (must be 1 with no exception)
fe_species_get_coding_table("master") |>
  group_by(name_eng, species_id) |> # display english names
  summarise(n = n()) |>
  arrange(as.numeric(species_id)) |> # just for the look of it
  print(n = Inf)

# Make an fe_species_master vector from a character vector of appropriate
# codes
spec_ids <- fe_species_master(
  c("pinus_002", "sorbus_002", "sorbus_002", "quercus_002", "prunus_001")
)

}
