% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{boot_te}
\alias{boot_te}
\title{Temporal Joint Bootstrap}
\usage{
boot_te(fit, boot_size, m, h = 1, seed = NULL)
}
\arguments{
\item{fit}{A list of \mjseqn{(k^\ast+m)} base forecast models ordered as
[lowest_freq' ...  highest_freq']'. It is important to note that the models
must have the \code{simulate()} function available and implemented as with
the package \pkg{forecast}, with the following mandatory parameters:
\emph{object}, \emph{innov}, \emph{future}, and \emph{nsim}.}

\item{boot_size}{The number of bootstrap replicates.}

\item{m}{Highest available sampling frequency per seasonal cycle (max. order
of temporal aggregation, \mjseqn{m}), or a subset of \mjseqn{p} factors
of \mjseqn{m}.}

\item{h}{Forecast horizon for the most temporally aggregated series.}

\item{seed}{An integer seed.}
}
\value{
A list with two elements: the seed used to sample the errors and
a (\mjseqn{boot\_size\times h(k^\ast+m)}) matrix
}
\description{
Joint block bootstrap for generating probabilistic base forecasts that take into account
the correlation between different temporal aggregation order (Girolimetto et al. 2023).
}
\references{
Girolimetto, D., Athanasopoulos, G., Di Fonzo, T., & Hyndman, R. J. (2023),
Cross-temporal Probabilistic Forecast Reconciliation,
\doi{10.48550/arXiv.2303.17277}.
}
\seealso{
Other bootstrap: 
\code{\link{boot_cs}()},
\code{\link{boot_ct}()}
}
\concept{bootstrap}
