% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_random_migration.R
\name{generate_random_migration}
\alias{generate_random_migration}
\title{Generate a migration structure with a random structure.}
\usage{
generate_random_migration(
  nb_sites = 4,
  type_structure = "forward",
  nb_max_neigh = 2,
  nb_birds = 100,
  death_probability_mode = "mean",
  death_probability_domain = c(0.01, 0.05),
  sojourn_mode = "mean",
  sojourn_domain = c(1, 10),
  flight_duration_mode = "mean",
  flight_duration_domain = c(1, 5),
  transition_mode = "equi",
  last_site_as_sink = TRUE,
  observation_hide = 0
)
}
\arguments{
\item{nb_sites, }{required number of site. Default is 4.}

\item{type_structure, }{Either "forward" or "two-directions". If "forward"
the transitions go forward only. If "two-directions", forward and backwards 
transitions  are possible. Default is "forward".}

\item{nb_max_neigh, }{the number of destinations of any site, unless structural 
constraints prevent it. Default is 2.}

\item{nb_birds, }{the number of birds on the initial sites. Birds are 
distributed over all sources sites. Default is 100.}

\item{death_probability_mode}{Either "mean" or "unif" 
(or a vector of such values of length the number of sites).  
If "mean" death probability are set to the mean value of 
the death_probability_domain. If "unif", the death probabilities are drawn 
uniformly into the range of the death_probability_domain. Default is "mean".}

\item{death_probability_domain}{Min and max of death probabilities. 
Default is c(0.01,0.05)}

\item{sojourn_mode}{Either "mean" or "unif" (or a vector of such values 
of length the number of sites). If "mean" sojourns mean time is set to 
the mean value of the sojourn_domain. If "unif", the sojourn mean time is 
drawn uniformly into the range of the sojourn_domain. Default is "mean".}

\item{sojourn_domain}{Min and max of sojourn mean time. Default is c(1,10)}

\item{flight_duration_mode, }{Either "mean" or "unif". If "mean" flight 
durations are set to the closest integer of the mean value of the 
flight_duration_domain. If "unif", the flight durations are drawn uniformly
into the range of the flight_duration_domain. Default is "mean".}

\item{flight_duration_domain, }{Min and max integers of flight durations. 
Default is c(1,5)}

\item{transition_mode}{Either "equi" or "unif". If "equi" transition 
are equiprobable taking into account the link_knowledge. If "unif" 
transitions are drawn uniformly. Default is "equi".}

\item{last_site_as_sink}{Boolean. If type_structure is set to "forward", 
last site is the only sink of the network. If TRUE, the last site is 
considered  as a specific sink where death probability is set to 1 and the 
sojourn mean time is set to the sum of sojourn mean time of other sites.
Default is TRUE.}

\item{observation_hide}{probability of hidding a single observation. 
Default is 0.}
}
\value{
A new generated migration structure
}
\description{
Generate a migration structure with a random structure.
}
\examples{
 migr = generate_random_migration()
}
