% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSFWER.R
\name{FSFWER.arbidept.p.adjust}
\alias{FSFWER.arbidept.p.adjust}
\title{Adjusted P-values for Fixed Sequence FWER Controlling Procedures under Arbitrary Dependence}
\usage{
FSFWER.arbidept.p.adjust(p, alpha=0.05, beta=0.5, tol = 1e-6,
  method = c("reject","accept","both"), make.decision = TRUE)
}
\arguments{
\item{p}{numeric vector of p-values (possibly with \code{\link[base]{NA}}s). Any other R is coerced by \code{\link[base]{as.numeric}}. Same as in \code{\link[stats]{p.adjust}}.}

\item{alpha}{significant level used to compare with adjusted p-values to make decisions, the default value is 0.05.}

\item{beta}{pre-specified constant satisfying \eqn{0 \le \beta <1}, only for \code{method="accept"}. The default value is \code{0.5}.}

\item{tol}{desired accuracy. The default value is \code{1e-6 }.}

\item{method}{adjustment method. See details.}

\item{make.decision}{logical; if  \code{TRUE} (default), then the output include the decision rules compared adjusted p-values with significant level \eqn{alpha}}
}
\value{
A numeric vector of the adjusted p-values (of the same length as \code{p}) if  \code{make.decision = FALSE}, or  a data frame including original p-values, adjusted p-values and decision rules if \code{make.decision = TRUE}.
}
\description{
Given a set of pre-ordered p-values and accuracy for the result, returns adjusted p-values using one of several generalized fixed sequence multiple testing procedures. The function also provides an option to make decisions given a pre-specified significant level \eqn{\alpha}.
}
\details{
The adjustment methods for Fixed Sequence multiple testing include the Procedure A1 only using numbers of rejections ("reject"), Procedure A2 only using numbers of acceptances ("accept") and Procedure A3 using both numbers of rejections and numbers of acceptances ("both").
 The three methods strongly control FWER under arbitrary dependence.
 The constant \code{beta} need to be specified only for the Procedure A2 (\code{"accept"}),  one can ignore this argument when using other methods.
}
\examples{
  ## Clinical trial example in Qiu et al. (2015)
Pval <- c(0.0008, 0.0135, 0.0197, 0.7237, 0.0003, 0.2779, 0.0054, 0.8473)
FSFWER.arbidept.p.adjust(p=Pval, alpha=0.05, method = "reject")
FSFWER.arbidept.p.adjust(p=Pval, alpha=0.05, beta=0.1, method = "accept")
FSFWER.arbidept.p.adjust(p=Pval, alpha=0.05, beta=0.5, method = "accept")
FSFWER.arbidept.p.adjust(p=Pval, alpha=0.05, beta=0.9, method = "accept")
FSFWER.arbidept.p.adjust(p=Pval, alpha=0.05, method = "both")
}
\author{
Yalin Zhu
}
\references{
Qiu, Z., Guo, W., & Lynch, G. (2015).
  On generalized fixed sequence procedures for controlling the FWER.
  \emph{Statistics in medicine}, 34(30), 3968-3983.
}
\seealso{
\code{\link{FSFDR.arbidept.p.adjust}} and   \code{\link{FSFDR.arbidept.p.adjust}} for fixed sequence FDR controlling procedures.
}

