% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nConst_MC.R
\name{nConst_MC}
\alias{nConst_MC}
\title{Density of a Lognormal-GPD dynamic mixture}
\usage{
nConst_MC(x, nreps, xiInst = 3, betaInst = 3)
}
\arguments{
\item{x}{(6 by 1) numerical vector: values of the parameters CA1, CA2, meanlog, sdlog, xi, beta.}

\item{nreps}{number of replications to be used in the computation of the integral in the normalizing
constant.}

\item{xiInst}{real: value of the shape parameter of the instrumental density. Default value equal to 3.}

\item{betaInst}{non-negative real: value of the scale parameter of the instrumental density. Default value equal to 3.}
}
\value{
Normalizing constant of the density of the lognormal-GPD mixture.
}
\description{
This function evaluates the normalizing constant of a Lognormal-GPD dynamic mixture via Monte Carlo simulation.
}
\examples{
nconst <- nConst_MC(c(1,2,0,0.5,0.25,3.5), 10000)
}
\keyword{dynamic}
\keyword{mixture.}
