% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NED_FUNCTIONS.R
\name{get_ned}
\alias{get_ned}
\title{Download and crop the 1 (~30 meter) or 1/3 (~10 meter) arc-second National Elevation Dataset.}
\usage{
get_ned(
  template,
  label,
  res = "1",
  extraction.dir = file.path(tempdir(), "FedData", "extractions", "ned", label),
  raster.options = c("COMPRESS=DEFLATE", "ZLEVEL=9"),
  force.redo = FALSE
)
}
\arguments{
\item{template}{An \code{\link[sf:sf]{Simple Feature}}
or \code{\link[terra:SpatRaster-class]{SpatRaster}} object to serve as a template for cropping.}

\item{label}{A character string naming the study area.}

\item{res}{A character string representing the desired resolution of the NED. '1'
indicates the 1 arc-second NED (the default), while '13' indicates the 1/3 arc-second dataset.}

\item{extraction.dir}{A character string indicating where the extracted and cropped DEM should be put.
The directory will be created if missing.}

\item{raster.options}{a vector of GDAL options passed to \link[terra:writeRaster]{terra::writeRaster}.}

\item{force.redo}{If an extraction for this template and label already exists, should a new one be created?}
}
\value{
A \code{SpatRaster} DEM cropped to the extent of the template.
}
\description{
\code{get_ned} returns a \code{SpatRaster} of elevation data cropped to a given
template study area.
}
\examples{
\dontrun{
# Get the NED (USA ONLY)
# Returns a `SpatRaster`
NED <-
  get_ned(
    template = FedData::meve,
    label = "meve"
  )

# Plot with terra::plot
terra::plot(NED)
}
}
