% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survfitjmcs.R
\name{survfitjmcs}
\alias{survfitjmcs}
\title{Prediction in Joint Models}
\usage{
survfitjmcs(
  object,
  seed = 100,
  ynewdata = NULL,
  cnewdata = NULL,
  u = NULL,
  M = 200,
  simulate = TRUE,
  quadpoint = NULL,
  ...
)
}
\arguments{
\item{object}{an object inheriting from class \code{jmcs}.}

\item{seed}{a random seed number to proceed Monte Carlo simulation. Default is 100.}

\item{ynewdata}{a data frame that contains the longitudinal and covariate information for the subjects 
for which prediction of survival probabilities is required.}

\item{cnewdata}{a data frame that contains the survival and covariate information for the subjects 
for which prediction of survival probabilities is required.}

\item{u}{a numeric vector of times for which prediction survival probabilities are to be computed.}

\item{M}{the number of Monte Carlo samples to be generated. Default is 200.}

\item{simulate}{logical; if \code{TRUE}, a Monte Carlo approach is used to estimate conditional probabilities. 
Otherwise, Gauss-Hermite quadrature rule is used for numerical integration to estimate instead. 
Default is \code{TRUE}.}

\item{quadpoint}{number of quadrature points used for estimating conditional probabilities when \code{simulate = FALSE}. Default is 20.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a list of matrices with conditional probabilities for subjects.
}
\description{
This function computes the conditional probability of 
surviving later times than the last observed time for which a longitudinal 
measurement was available.
}
\seealso{
\code{\link{jmcs}}
}
\author{
Shanpeng Li \email{lishanpeng0913@ucla.edu}
}
