\name{run.strong.peaks}
\alias{run.strong.peaks}
\title{Locate Peaks that are "Large" in All Samples}
\description{
Takes the file generated by \code{\link{run.peaks}}, extracts all peaks that are \dQuote{large} in 
all samples, and writes the results to a file.
}
\usage{
run.strong.peaks(cor.thresh = 0.8, isotope.dist = 7, pre.align = FALSE, 
                 root.dir = ".", lrg.dir, lrg.file = "lrg.peaks.RData", 
                 overwrite = FALSE, use.par.file = FALSE, 
                 par.file = "parameters.RData")
}
\arguments{
  \item{cor.thresh}{threshhold correlation for declaring two peaks to be isotopes}
  \item{isotope.dist}{maximum difference in mass for declaring two peaks to be isotopes}
  \item{pre.align}{either \code{FALSE}, or a numeric vector of shifts to apply to spectra, or a two-component list
      (of the form described in the \code{Note} section below) to be used before identifying peaks from different
      spectra}
  \item{root.dir}{string containing location of raw data directory}
  \item{lrg.dir}{directory for significant peaks file; default is  \code{paste(root.dir, "/Large_Peaks", sep = "")}}
  \item{lrg.file}{string containing name of significant peaks file}
  \item{overwrite}{logical; whether to replace existing files with new ones}
  \item{use.par.file}{logical; if \code{TRUE}, then parameters are read from 
      \code{par.file} in directory \code{root.dir}}
  \item{par.file}{string containing name of parameters file}
}
\details{Reads in information from file created by \code{\link{run.lrg.peaks}}, locates peaks which appear in
all samples, and overwrites the file \code{lrg.file} in \code{lrg.dir}.  The resulting file contains variables
\tabular{ll}{ \tab \cr
    \code{amps}\tab data frame of amplitudes of non-isotope peaks that occur in all samples\cr
    \code{centers}\tab data frame of centers of non-isotope peaks that occur in all samples\cr
    \code{lrg.peaks}\tab the data frame of significant peaks created by \code{\link{run.lrg.peaks}}\cr
}
    and is ready to be used by \code{\link{run.cluster.matrix}}.}
\value{
No value returned; the file is simply created.
}
\references{
Barkauskas, D.A. \emph{et al}. (2008) \dQuote{Detecting glycan cancer biomarkers in serum 
samples using MALDI FT-ICR mass spectrometry data}.  Submitted to \emph{Bioinformatics}
}
\author{Don Barkauskas (\email{barkda@wald.ucdavis.edu})}
\note{
A peak is \dQuote{large} if its value of \code{Max_hat} is at least \code{numsds} standard 
deviations above the mean value in the data generated by \code{\link{run.peaks}} for the 
spectrum it comes from. 

If \code{use.par.file = TRUE}, then the parameters read in from the file overwrite any arguments entered in the
function call.

\code{pre.align} is used if the spectra have not already been aligned by the mass spectroscopists.
If it is not \code{FALSE}, it can either be a vector of additive shifts to be applied to the 
spectra, or a list with components \code{targets} and \code{actual}.  In the last case, \code{targets}
is a vector of target masses, and \code{actual} is a matrix with \code{length(targets)}
columns and a row for each spectrum, \code{actual[i,j]} being the mass in spectrum \code{i} that should  
be matched exactly to \code{target[j]}, with \code{NA} being a valid entry in \code{actual}.  
The matching is done (depending on the number of non-missing values in row \code{i}) either with a
simple shift (one non-missing value), an affine transformation (two non-missing values), a 
piecewise affine transformation (three non-missing values), or an interpolation spline (four 
or more non-missing values).
}
\seealso{\code{\link{run.lrg.peaks}}, \code{\link{run.cluster.matrix}}, 
\code{\link[splines]{interpSpline}}}
\examples{}