% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSD.R
\name{compute.fsd}
\alias{compute.fsd}
\title{Fraction of Standard Deviation (FSD)}
\usage{
compute.fsd(Y, X, verbose = F)
}
\arguments{
\item{Y}{vector of imputed values}

\item{X}{vector of true values}

\item{verbose}{if TRUE, print advice about the quality of the model}
}
\description{
Compute the Fraction of Standard Deviation (FSD) of two univariate signals Y (imputed values) and X (true values).
}
\details{
This function returns the FSD value between two univariate signals.
FSD value approaches zero means that a better performance method for the imputation task.
Y and X must have the same length, conversely an error will be appeared.
In both input vectors, NA will be exluded with a warning diplayed.
}
\examples{
data(dataFSMUMI)
X <- dataFSMUMI[, 1] ; Y <- dataFSMUMI[, 2]
compute.fsd(Y,X)
compute.fsd(Y,X, verbose = TRUE)

# By definition, if true and imputed values are equal and constant,
# FSD = 0.
X <- rep(runif(1), 10)
Y <- X
compute.fsd(Y,X)

# However, if true and imputed values are constant but different,
# FSD is not calculable. An error is displayed.
\dontrun{
X <- rep(runif(1), 10);Y <- rep(runif(1), 10)
compute.fsd(Y,X)}
}
\author{
Thi-Thu-Hong Phan, Andre Bigand, Emilie Poisson-Caillault
}
