% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CIDists.R
\name{binCI}
\alias{binCI}
\title{Confidence intervals for binomial probability of success.}
\usage{
binCI(x, n, conf.level = 0.95, type = c("wilson", "exact", "asymptotic"),
  verbose = FALSE)
}
\arguments{
\item{x}{A single or vector of numbers that contains the number of observed successes.}

\item{n}{A single or vector of numbers that contains the sample size.}

\item{conf.level}{A single number that indicates the level of confidence (default is \code{0.95}).}

\item{type}{A string that identifies the type of method to use for the calculations.  See details.}

\item{verbose}{A logical that indicates whether \code{x}, \code{n}, and \code{x/n} should be included in the returned matrix (\code{=TRUE}) or not (\code{=FALSE}; DEFAULT).}
}
\value{
A #x2 matrix that contains the lower and upper confidence interval bounds as columns and, if \code{verbose=TRUE} \code{x}, \code{n}, and \code{x/n} .
}
\description{
Uses one of three methods to compute a confidence interval for the probability of success (p) in a binomial distribution.
}
\details{
This function will compute confidence interval for three possible methods chosen with the \code{type} argument.

\tabular{ll}{
 \code{type="wilson"} \tab Wilson's (Journal of the American Statistical Association, 1927) confidence interval for a proportion.  This is the score CI, based on inverting the asymptotic normal test using the null standard error. \cr
 \code{type="exact"} \tab Computes the Clopper/Pearson exact CI for a binomial success probability. \cr
 \code{type="asymptotic"} \tab This uses the normal distribution approximation. \cr
}

Note that Agresti and Coull (2000) suggest that the Wilson interval is the preferred method and is, thus, the default \code{type}.
}
\note{
This is primarily a wrapper function for \code{\link[epitools]{binom.exact}}, \code{\link[epitools]{binom.wilson}}, and \code{\link[epitools]{binom.approx}} from the \pkg{epitools} package.
}
\examples{
## All types at once
binCI(7,20)

## Individual types
binCI(7,20,type="wilson")
binCI(7,20,type="exact")
binCI(7,20,type="asymptotic")
binCI(7,20,type="asymptotic",verbose=TRUE)

## Multiple types
binCI(7,20,type=c("exact","asymptotic"))
binCI(7,20,type=c("exact","asymptotic"),verbose=TRUE)

## Use with multiple inputs
binCI(c(7,10),c(20,30),type="wilson")
binCI(c(7,10),c(20,30),type="wilson",verbose=TRUE)

}
\author{
Derek H. Ogle, \email{derek@derekogle.com}
}
\references{
Agresti, A. and B.A. Coull.  1998.  Approximate is better than \dQuote{exact} for interval estimation of binomial proportions.  American Statistician, 52:119-126.
}
\seealso{
See \code{\link{binom.test}}; \code{binconf} in \pkg{Hmisc}; \code{\link[epitools]{binom.exact}}, \code{\link[epitools]{binom.wilson}}, and \code{\link[epitools]{binom.approx}} in \pkg{epitools}, and functions in \pkg{binom}.
}
\keyword{htest}

