% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_freg.R
\name{predict.freg}
\alias{predict.freg}
\title{Predict FREG model}
\usage{
\method{predict}{freg}(object, ..., newdata = NULL)
}
\arguments{
\item{object}{FREG model for which predictions are computed}

\item{...}{additional arguments relevant for the generic method}

\item{newdata}{an optional argument. Newdata should be organized as a list. The elements of the list
are covariates from FREG model, respectively. No data transformation is needed. Thus, functional covariates are entered in the list \code{newdata}
in their raw form. The \code{predict.freg} function will take care of the transformation of such covariates into the functional form of their equivalents from FREG model.}
}
\value{
predictions of dependent variable \code{y}
}
\description{
Prediction of FREG model
}
\examples{
\donttest{
library(fda)
y = log10(apply(CanadianWeather$dailyAv[1:334,,2],2,sum))
x = CanadianWeather$dailyAv[1:334,,1] # temperature
xbasis = create.fourier.basis(c(1,334),5)
xfd = smooth.basis(c(1:335),x,xbasis)$fd
bbasis = create.fourier.basis(c(1,334),5)
latitude = CanadianWeather$coordinates[,1]
longitude = CanadianWeather$coordinates[,2]
xfdlist = list(xfd, latitude, longitude)
cbasis = create.constant.basis(c(1,334))
betalist = list(bbasis, cbasis, cbasis)
formula = y ~ xfd + latitude + longitude
freg.model = freg(formula = formula, betalist = betalist)
# Prediction with new data included
newdata = list(CanadianWeather$dailyAv[1:365,,1], latitude, longitude)
# newdata = list(xfd_1, latitude, longitude) #funct. and scalar variable(s)
yhat = predict(freg.model, newdata = newdata)
}
}
